/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.tree.ds;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.qubership.atp.dataset.service.jpa.ContextType;
import org.qubership.atp.dataset.service.jpa.impl.DataSetParameterProvider;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetListContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.GroupContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.ParameterContext;
import org.qubership.atp.dataset.service.jpa.model.tree.ds.DataSetGroup;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;

public class DataSetTree {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, AbstractParameter> parameters = new LinkedHashMap<String, AbstractParameter>();
    private Map<String, DataSetGroup> groups = new LinkedHashMap<String, DataSetGroup>();

    public DataSetTree(DataSetContext dataSetContext, int column, boolean evaluate, MacroContext macroContext, DataSetListContext dataSetListContext, DataSetParameterProvider dataSetParameterProvider, ContextType contextType) {
        List<ParameterContext> parametersContexts = dataSetContext.getParameters();
        for (ParameterContext parametersContext : parametersContexts) {
            AbstractParameter resolvedParameter = dataSetParameterProvider.getDataSetParameterResolved(macroContext.getDataSetListContext().getDataSetListId(), parametersContext.getParameterId(), parametersContext.getType(), evaluate, macroContext, new ParameterPositionContext(Collections.emptyList(), column, dataSetContext.getId(), parametersContext.getOrder(), dataSetListContext.getDataSetListId()));
            this.parameters.put(parametersContext.getName(), resolvedParameter);
        }
        for (GroupContext group : dataSetListContext.getGroups()) {
            DataSetGroup dataSetGroup = new DataSetGroup(group, column, evaluate, macroContext, dataSetParameterProvider, contextType, dataSetListContext.getRootOverlapNode());
            if (contextType == ContextType.NO_NULL_VALUES && dataSetGroup.getGroups().isEmpty() && dataSetGroup.getParameters().isEmpty()) continue;
            this.groups.put(group.getName(), dataSetGroup);
        }
    }

    public Map<String, AbstractParameter> getParameters() {
        return this.parameters;
    }

    public Map<String, DataSetGroup> getGroups() {
        return this.groups;
    }
}

