/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.tree.ds.itf;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.qubership.atp.dataset.service.jpa.model.tree.ds.DataSetGroup;
import org.qubership.atp.dataset.service.jpa.model.tree.ds.itf.AttributeSerializer;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractParameter;

public class GroupSerializer
extends AttributeSerializer {
    private String name;
    private DataSetGroup group;
    private JsonGenerator jsonGenerator;

    GroupSerializer(String name, DataSetGroup group, JsonGenerator jsonGenerator) {
        this.name = name;
        this.group = group;
        this.jsonGenerator = jsonGenerator;
    }

    @Override
    public void serialize() throws IOException {
        this.jsonGenerator.writeFieldName(this.name);
        if (this.group.getDataSetId() == null) {
            this.jsonGenerator.writeString("");
        } else {
            this.jsonGenerator.writeStartObject();
            TreeMap<Long, AttributeSerializer> attributes = new TreeMap<Long, AttributeSerializer>();
            Map<String, AbstractParameter> parameters = this.group.getParameters();
            for (String parameterName : parameters.keySet()) {
                AbstractParameter parameter = parameters.get(parameterName);
                AttributeSerializer serializer = AttributeSerializer.getSerializer(parameterName, parameter, this.jsonGenerator);
                attributes.put(parameter.getOrder(), serializer);
            }
            Map<String, DataSetGroup> groups = this.group.getGroups();
            for (String groupName : groups.keySet()) {
                DataSetGroup group = groups.get(groupName);
                AttributeSerializer serializer = AttributeSerializer.getSerializer(groupName, group, this.jsonGenerator);
                attributes.put(group.getOrder(), serializer);
            }
            for (AttributeSerializer serializer : attributes.values()) {
                serializer.serialize();
            }
            this.jsonGenerator.writeEndObject();
        }
    }
}

