/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.tree.params;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;

public class FileParameter
extends AbstractParameter {
    private Map<String, String> valueRef = new HashMap<String, String>();
    private String value;

    public FileParameter(Parameter parameter, FileData fileData, ParameterPositionContext parameterPositionContext) {
        if (fileData != null) {
            this.value = parameter.getId().toString() + "." + fileData.getFileType();
            this.valueRef.put("contentType", fileData.getContentType());
            this.valueRef.put("url", fileData.getUrl());
        }
        this.setOrder(parameterPositionContext.getOrder());
    }

    public FileParameter(ParameterPositionContext parameterPositionContext) {
        this.setOrder(parameterPositionContext.getOrder());
    }

    @Override
    public AttributeTypeName getType() {
        return AttributeTypeName.FILE;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getInItfFormatValue() {
        return this.valueRef.get("url");
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, String> getValueRef() {
        return this.valueRef;
    }

    @Override
    public boolean isNullValue() {
        return this.value == null;
    }
}

