/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.tree.params.macros;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.dataset.antlr4.TextParameterParser;
import org.qubership.atp.dataset.model.utils.Utils;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.impl.macro.CachedDslMacroResult;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.PathStep;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractTextParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.AbstractRef;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefDslMacro
extends AbstractRef {
    private static final Logger LOG = LoggerFactory.getLogger(RefDslMacro.class);
    public static final String MACRO_NAME = "REF_DSL";

    public RefDslMacro(String realMacroName, MacroContext macroContext, ParameterPositionContext parameterPositionContext) {
        super(realMacroName, macroContext, parameterPositionContext);
    }

    @Override
    public String getEvaluatedValue(List<String> arguments) {
        if (Objects.isNull(arguments)) {
            return null;
        }
        if (arguments.isEmpty()) {
            return "";
        }
        String[] splits = String.join((CharSequence)"", arguments).split("\\.");
        if (splits.length < 3) {
            throw new IllegalArgumentException("Invalid parameter path");
        }
        PathStep dataSetList = new PathStep(splits[0]);
        PathStep dataSet = new PathStep(splits[1]);
        LinkedList<PathStep> attributeGroupPath = new LinkedList<PathStep>();
        for (int i = 2; i < splits.length - 1; ++i) {
            attributeGroupPath.add(new PathStep(splits[i]));
        }
        PathStep attribute = new PathStep(splits[splits.length - 1]);
        try {
            this.collectDataSetAndDataSetListsUuids(dataSet, dataSetList);
            UUID dataSetListId = this.getParameterPositionContext().getDataSetListId();
            UUID dataSetId = this.getParameterPositionContext().getDataSetInColumnId();
            if (dataSetListId != null && dataSetId != null && dataSetList.matches(null, dataSetListId) && dataSet.matches(null, dataSetId)) {
                return this.getMacroContext().getTextParameterFromCachedContextByNamesPath(this.getParameterPositionContext(), attributeGroupPath, attribute);
            }
            UUID visibilityAreaId = this.getMacroContext().getDataSetListContext().getVisibilityAreaId();
            CachedDslMacroResult cachedDslTextParameter = this.getMacroContext().getCachedDslTextParameter(dataSetList, dataSet, attributeGroupPath, attribute);
            if (cachedDslTextParameter == null) {
                String value = this.getMacroContext().getDslTextParameter(visibilityAreaId, dataSetList, dataSet, attributeGroupPath, attribute);
                TextParameterParser parser = new TextParameterParser(this.getMacroContext(), this.getParameterPositionContext());
                if (StringUtils.isEmpty((String)value)) {
                    return value;
                }
                List<AbstractTextParameter> parsedResult = parser.parse(value, this.isEvaluate());
                StringBuilder stringBuilder = new StringBuilder();
                for (AbstractTextParameter abstractTextParameter : parsedResult) {
                    stringBuilder.append(abstractTextParameter.getValue());
                }
                String result = stringBuilder.toString();
                this.getMacroContext().storeCachedDslTextParameter(dataSetList, dataSet, attributeGroupPath, attribute, result);
                return result;
            }
            return cachedDslTextParameter.getValue();
        }
        catch (DataSetServiceException e) {
            return e.getMessage();
        }
    }

    @Override
    public String getUnevaluatedValue(String childrenValue) {
        if (StringUtils.isEmpty((String)childrenValue)) {
            return super.getUnevaluatedValue(childrenValue);
        }
        String[] splits = childrenValue.split("\\.");
        if (splits.length < 3) {
            return super.getUnevaluatedValue(childrenValue);
        }
        try {
            LinkedList<String> content = new LinkedList<String>();
            if (Utils.isUuid(splits[0])) {
                String dataSetListName = this.getMacroContext().getDataSetListName(UUID.fromString(splits[0]));
                if (dataSetListName == null) {
                    dataSetListName = splits[0];
                }
                content.add(dataSetListName);
            } else {
                content.add(splits[0]);
            }
            if (Utils.isUuid(splits[1])) {
                String dataSetName = this.getMacroContext().getDataSetName(UUID.fromString(splits[1]));
                if (dataSetName == null) {
                    dataSetName = splits[1];
                }
                content.add(dataSetName);
            } else {
                content.add(splits[1]);
            }
            for (int i = 2; i < splits.length; ++i) {
                if (Utils.isUuid(splits[i])) {
                    String attributeName = this.getMacroContext().getAttributeName(UUID.fromString(splits[i]));
                    if (attributeName == null) {
                        attributeName = splits[i];
                    }
                    content.add(attributeName);
                    continue;
                }
                content.add(splits[i]);
            }
            return super.getUnevaluatedValue(StringUtils.join(content, (String)"."));
        }
        catch (Exception e) {
            LOG.debug("Error macro values translation", (Throwable)e);
            return super.getUnevaluatedValue(childrenValue);
        }
    }

    private void collectDataSetAndDataSetListsUuids(PathStep dataSet, PathStep dataSetList) throws DataSetServiceException {
        UUID dataSetListId;
        if (dataSetList.getId() == null) {
            UUID visibilityAreaId = this.getMacroContext().getDataSetListContext().getVisibilityAreaId();
            DataSetList discoveredDataSetList = this.getMacroContext().getDataSetList(visibilityAreaId, dataSetList);
            dataSetListId = discoveredDataSetList.getId();
        } else {
            dataSetListId = dataSetList.getId();
        }
        this.dataSetLists.add(dataSetListId);
        if (dataSet.getId() == null) {
            UUID dataSetId = this.getMacroContext().getDataSetIdByNameAndDataSetList(dataSet.getName(), dataSetListId);
            if (dataSetId != null) {
                this.dataSets.add(dataSetId);
            }
        } else {
            this.dataSets.add(dataSet.getId());
        }
    }
}

