/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.rest.server;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemResponseDto;
import org.qubership.atp.dataset.service.rest.dto.versioning.UiManDataSetListJDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="HistoryController", description="Model History API")
public interface HistoryControllerApi {
    @Operation(operationId="getAllHistory", summary="Finds all changes history for defined data set list", tags={"history-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=HistoryItemResponseDto.class))}), @ApiResponse(responseCode="404", description="Entity Id not found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/history/{projectId}/datasetlist/{id}"}, produces={"application/json"})
    public ResponseEntity<HistoryItemResponseDto> getAllHistory(@Parameter(name="projectId", description="", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID var2, @Parameter(name="offset", description="") @Valid @RequestParam(value="offset", required=false, defaultValue="0") Integer var3, @Parameter(name="limit", description="") @Valid @RequestParam(value="limit", required=false, defaultValue="10") Integer var4);

    @Operation(operationId="getRevisionDetails", summary="Find model of Dataset List by revision", tags={"history-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UiManDataSetListJDto.class))}), @ApiResponse(responseCode="404", description="Entity Id not found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/history/{projectId}/datasetlist/revisionDetails/{entityId}/{revision}"}, produces={"application/json"})
    public ResponseEntity<UiManDataSetListJDto> getRevisionDetails(@Parameter(name="projectId", description="", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="entityId", description="", required=true) @PathVariable(value="entityId") UUID var2, @Parameter(name="revision", description="", required=true) @PathVariable(value="revision") Integer var3);

    @Operation(operationId="restoreToRevision", summary="Restore the state of the provided entity to defined revision", tags={"history-controller"}, responses={@ApiResponse(responseCode="200", description="Revision was restored successfully"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Entity Id not found"), @ApiResponse(responseCode="500", description="Revision was not restored")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/history/restore/{projectId}/datasetlist/{id}/revision/{revisionId}"})
    public ResponseEntity<Void> restoreToRevision(@Parameter(name="projectId", description="", required=true) @PathVariable(value="projectId") UUID var1, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID var2, @Parameter(name="revisionId", description="", required=true) @PathVariable(value="revisionId") Integer var3);
}

