/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.rest.server;

import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.dataset.model.api.saga.requests.CopyDataSetListsRequest;
import org.qubership.atp.dataset.model.api.saga.requests.RevertRequest;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.rest.server.CopyDataSetListsResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/saga"})
public class SagaController {
    private final JpaDataSetListService jpaDataSetListService;
    private final DataSetListService dataSetListService;
    static final String X_SAGA_SESSION_ID_HEADER = "X-Saga-Session-Id";

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),#request.getProjectId(),'CREATE')")
    @PostMapping(value={"/dsl/copy"})
    @Operation(summary="Copy DSL with name provided.")
    public List<CopyDataSetListsResponse> copyDataSetLists(@RequestHeader(name="X-Saga-Session-Id") UUID sagaSessionId, @RequestBody @Valid CopyDataSetListsRequest request) {
        return this.jpaDataSetListService.copyDataSetLists(request.getDataSetListIds(), request.isUpdateReferences(), request.getProjectId(), request.getPostfix(), request.getPrevNamePattern(), sagaSessionId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),#request.getProjectId(),'DELETE')")
    @PostMapping(value={"/dsl/revert"})
    public void revertDataSetLists(@RequestHeader(name="X-Saga-Session-Id") UUID sagaSessionId, @RequestBody @Valid RevertRequest request) {
        this.dataSetListService.revert(sagaSessionId, request);
    }

    public SagaController(JpaDataSetListService jpaDataSetListService, DataSetListService dataSetListService) {
        this.jpaDataSetListService = jpaDataSetListService;
        this.dataSetListService = dataSetListService;
    }
}

