/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.rest.server;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.qubership.atp.dataset.service.jpa.JpaVisibilityAreaService;
import org.qubership.atp.dataset.service.jpa.model.VisibilityAreaFlatModel;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/va"})
public class VisibilityAreaController {
    @Autowired
    protected JpaVisibilityAreaService visibilityAreaService;

    @PreAuthorize(value="@entityAccess.isAdmin()")
    @PutMapping
    @AuditAction(auditAction="Create new visibility area with name : {{#name}}")
    @Operation(summary="Creates new visibility area with provided name and order.")
    public ResponseEntity<UUID> create(@RequestParam(value="name") String name, HttpServletRequest request) {
        UUID vaId = this.visibilityAreaService.getOrCreateWithName(name);
        String url = request.getRequestURL().append("/").append(vaId.toString()).toString();
        URI uri = URI.create(url);
        return ResponseEntity.created((URI)uri).body((Object)vaId);
    }

    @PreAuthorize(value="@entityAccess.isAdmin()")
    @DeleteMapping(value={"/{visibilityAreaId}"})
    @AuditAction(auditAction="Delete visibility area: {{#visibilityAreaId}}")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Deletes selected VA.")
    public void delete(@PathVariable(value="visibilityAreaId") UUID visibilityAreaId) {
        this.visibilityAreaService.deleteById(visibilityAreaId);
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @GetMapping
    @AuditAction(auditAction="Get all visibility areas")
    @Operation(summary="Returns all visibility areas.", responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=VisibilityAreaFlatModel.class)))})})
    public List<VisibilityAreaFlatModel> getVisibilityAreas() {
        return this.visibilityAreaService.getAll();
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @GetMapping(value={"/sorted"})
    @AuditAction(auditAction="Get all visibility areas sorted by name")
    @Operation(summary="Returns all visibility areas sorted by name.", responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=VisibilityAreaFlatModel.class)))})})
    public List<VisibilityAreaFlatModel> getVisibilityAreasSorted() {
        return this.visibilityAreaService.getAllSortedByNameAsc();
    }

    @PreAuthorize(value="@entityAccess.isAdmin()")
    @PostMapping(value={"/{visibilityAreaId}"})
    @AuditAction(auditAction="Rename visibility area for ptoject: {{#visibilityAreaId}}")
    @Operation(summary="Renames selected VA.")
    public boolean rename(@PathVariable(value="visibilityAreaId") UUID visibilityAreaId, @RequestParam(value="name") String name) {
        return this.visibilityAreaService.setName(visibilityAreaId, name);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),#sourceAreaId, 'CREATE')")
    @PostMapping(value={"/{visibilityAreaId}/copyTo"})
    @AuditAction(auditAction="Copy DSL with name provided for project: {{#visibilityAreaId}}")
    @Operation(summary="Copy DSL with name provided.")
    public void copyToVisibilityArea(@PathVariable(value="visibilityAreaId") UUID sourceAreaId, @RequestBody UUID targetAreaId) {
        this.visibilityAreaService.copyDataSetListsToVisibilityArea(sourceAreaId, targetAreaId);
    }
}

