/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.changes.processors;

import java.util.List;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.NewObject;
import org.qubership.atp.dataset.service.rest.dto.versioning.ChangeSummary;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.versioning.service.changes.DataSetComparable;
import org.qubership.atp.dataset.versioning.service.changes.DataSetListComparable;
import org.qubership.atp.dataset.versioning.service.changes.processors.AbstractChangeProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class CreateDataSetProcessor
extends AbstractChangeProcessor {
    private static final Logger log = LoggerFactory.getLogger(CreateDataSetProcessor.class);

    @Override
    public boolean isApplicable(Diff diff, DataSetListComparable actualEntity) {
        List<NewObject> newDataSets = CreateDataSetProcessor.filterChangesByTypeAndAffectedType(diff, NewObject.class, "DataSet");
        return !newDataSets.isEmpty();
    }

    @Override
    public HistoryItemDto createHistoryItem(Diff diff, DataSetListComparable oldEntity, DataSetListComparable actualEntity) {
        NewObject newDataSet = CreateDataSetProcessor.filterChangesByTypeAndAffectedType(diff, NewObject.class, "DataSet").get(0);
        String dataSetName = ((DataSetComparable)newDataSet.getAffectedObject().get()).getName();
        HistoryItemDto historyItem = new HistoryItemDto();
        historyItem.setChangeSummary(ChangeSummary.ADDED.toString());
        historyItem.setDataSet(dataSetName);
        log.trace("Diff processed by NewDataSetChangeProcessor");
        return historyItem;
    }
}

