/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.changes.processors;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.ListUtils;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.NewObject;
import org.javers.core.diff.changetype.container.SetChange;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.service.rest.dto.versioning.ChangeSummary;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.versioning.service.changes.AttributeComparable;
import org.qubership.atp.dataset.versioning.service.changes.DataSetListComparable;
import org.qubership.atp.dataset.versioning.service.changes.ParameterComparable;
import org.qubership.atp.dataset.versioning.service.changes.processors.AbstractChangeProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=3)
public class CreateParameterProcessor
extends AbstractChangeProcessor {
    private static final Logger log = LoggerFactory.getLogger(CreateParameterProcessor.class);
    @Autowired
    ModelsProvider modelsProvider;

    @Override
    public boolean isApplicable(Diff diff, DataSetListComparable actualEntity) {
        Optional<AttributeComparable> optionalAttribute;
        List<NewObject> newParameters = CreateParameterProcessor.filterChangesByTypeAndAffectedType(diff, NewObject.class, "Parameter");
        List<SetChange> setChangesParameters = CreateParameterProcessor.filterChangesByTypeAndProperty(diff, SetChange.class, "parameters");
        if (!newParameters.isEmpty() && !setChangesParameters.isEmpty() && (optionalAttribute = this.getTopLevelAffectedAttribute(actualEntity, setChangesParameters)).isPresent()) {
            AttributeComparable affectedAttribute = optionalAttribute.get();
            List<UUID> topLevelAffectedParametersIds = this.getTopLevelAffectedParametersIds(affectedAttribute, newParameters);
            return !topLevelAffectedParametersIds.isEmpty();
        }
        return false;
    }

    @Override
    public HistoryItemDto createHistoryItem(Diff diff, DataSetListComparable oldEntity, DataSetListComparable actualEntity) {
        List<NewObject> newParameters = CreateParameterProcessor.filterChangesByTypeAndAffectedType(diff, NewObject.class, "Parameter");
        List<SetChange> setChangesParameters = CreateParameterProcessor.filterChangesByTypeAndProperty(diff, SetChange.class, "parameters");
        AttributeComparable affectedAttribute = this.getTopLevelAffectedAttribute(actualEntity, setChangesParameters).get();
        UUID parameterId = this.getTopLevelAffectedParametersIds(affectedAttribute, newParameters).get(0);
        String attributeName = affectedAttribute.getName();
        ParameterComparable parameter = CreateParameterProcessor.getParameterById(actualEntity, parameterId);
        String dataSetName = CreateParameterProcessor.getDataSetById(actualEntity, parameter.getDataSet()).getName();
        HistoryItemDto historyItem = new HistoryItemDto();
        historyItem.setChangeSummary(ChangeSummary.CHANGED.toString());
        historyItem.setAttribute(attributeName);
        historyItem.setDataSet(dataSetName);
        if (parameter.getValue() != null) {
            historyItem.setNewValue(this.getValuePretty(parameter.getValue().toString(), parameter.getType(), this.modelsProvider));
        }
        log.trace("Diff processed by NewParameterChangeProcessor");
        return historyItem;
    }

    private Optional<AttributeComparable> getTopLevelAffectedAttribute(DataSetListComparable dsl, List<SetChange> setChangesParameters) {
        List<UUID> dataSetListAttributesIds;
        List<UUID> affectedAttributesIds = this.getAffectedIds(setChangesParameters);
        List topLevelAffectedAttributesIds = ListUtils.intersection(affectedAttributesIds, dataSetListAttributesIds = this.getDataSetListAttributesIds(dsl));
        return !topLevelAffectedAttributesIds.isEmpty() ? Optional.of(CreateParameterProcessor.getAttributeById(dsl, (UUID)topLevelAffectedAttributesIds.get(0))) : Optional.empty();
    }

    private List<UUID> getTopLevelAffectedParametersIds(AttributeComparable affectedAttribute, List<NewObject> newParameters) {
        List<UUID> attributeParametersIds = this.getAttributeParametersIds(affectedAttribute);
        List<UUID> newParametersIds = this.getAffectedIds(newParameters);
        return ListUtils.intersection(attributeParametersIds, newParametersIds);
    }

    private List<UUID> getAffectedIds(List<? extends Change> changes) {
        return changes.stream().map(setChange -> (UUID)setChange.getAffectedLocalId()).collect(Collectors.toList());
    }

    private List<UUID> getDataSetListAttributesIds(DataSetListComparable dsl) {
        return dsl.getAttributes().stream().map(AttributeComparable::getId).collect(Collectors.toList());
    }

    private List<UUID> getAttributeParametersIds(AttributeComparable attribute) {
        return attribute.getParameters().stream().map(ParameterComparable::getId).collect(Collectors.toList());
    }
}

