/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.changes.processors;

import java.util.List;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.ValueChange;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.service.rest.dto.versioning.ChangeSummary;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.versioning.model.domain.ParameterSnapshot;
import org.qubership.atp.dataset.versioning.service.changes.AttributeKeyComparable;
import org.qubership.atp.dataset.versioning.service.changes.DataSetListComparable;
import org.qubership.atp.dataset.versioning.service.changes.processors.AbstractChangeProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=10)
public class UpdateOverlappedProcessor
extends AbstractChangeProcessor {
    private static final Logger log = LoggerFactory.getLogger(UpdateOverlappedProcessor.class);
    @Autowired
    ModelsProvider modelsProvider;

    @Override
    protected boolean isApplicable(Diff diff, DataSetListComparable actualEntity) {
        List<ValueChange> attributeKeysChanges = UpdateOverlappedProcessor.filterChangesByTypeAndAffectedType(diff, ValueChange.class, "AttributeKey");
        return !attributeKeysChanges.isEmpty();
    }

    @Override
    protected HistoryItemDto createHistoryItem(Diff diff, DataSetListComparable oldEntity, DataSetListComparable actualEntity) {
        ParameterSnapshot newParameter;
        ValueChange attributeKeyChange = UpdateOverlappedProcessor.filterChangesByTypeAndAffectedType(diff, ValueChange.class, "AttributeKey").get(0);
        AttributeKeyComparable attributeKey = (AttributeKeyComparable)attributeKeyChange.getAffectedObject().get();
        ParameterSnapshot parameter = attributeKey.getParameter();
        String dataSetName = UpdateOverlappedProcessor.getDataSetById(actualEntity, parameter.getDataSetId()).getName();
        String value = parameter.getText();
        HistoryItemDto historyItem = new HistoryItemDto();
        historyItem.setChangeSummary(ChangeSummary.OVERRIDE_CHANGED.toString());
        historyItem.setAttribute(attributeKey.getAttributeName());
        historyItem.setDataSet(dataSetName);
        historyItem.setNewValue(value);
        ParameterSnapshot oldParameter = (ParameterSnapshot)attributeKeyChange.getLeft();
        if (oldParameter != null) {
            historyItem.setOldValue(this.getValuePretty(oldParameter.getText(), oldParameter.getType(), this.modelsProvider));
        }
        if ((newParameter = (ParameterSnapshot)attributeKeyChange.getRight()) != null) {
            historyItem.setNewValue(this.getValuePretty(newParameter.getText(), oldParameter.getType(), this.modelsProvider));
        }
        log.trace("Diff processed by ChangeOverlappedParameterProcessor");
        return historyItem;
    }
}

