/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.impl;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.javers.core.Javers;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.InstanceIdDTO;
import org.javers.repository.jql.JqlQuery;
import org.javers.repository.jql.QueryBuilder;
import org.javers.shadow.Shadow;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.versioning.exception.DataSetListIdNotFound;
import org.qubership.atp.dataset.versioning.model.domain.DataSetListSnapshot;
import org.qubership.atp.dataset.versioning.service.DataSetListSnapshotService;
import org.qubership.atp.dataset.versioning.service.JaversCommitService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnProperty(prefix="atp-dataset", name={"javers.enabled"}, matchIfMissing=true)
public class DataSetListSnapshotServiceImpl
implements DataSetListSnapshotService {
    private static final Logger log = LoggerFactory.getLogger(DataSetListSnapshotServiceImpl.class);
    @Autowired
    private final ModelsProvider modelsProvider;
    @Autowired
    private final JaversCommitService javersCommitService;
    @Autowired
    private final Javers javers;

    @Override
    @Transactional
    public void commitEntity(UUID dataSetListId) {
        this.commitWithProperties(this.modelsProvider.getDataSetListById(dataSetListId), Collections.emptyMap());
    }

    @Override
    public void findAndCommitIfExists(UUID id) {
        DataSetList dataSetList = this.modelsProvider.getDataSetListById(id);
        if (dataSetList != null) {
            this.commitEntity(id);
        }
    }

    @Override
    public void findAndCommitRestored(UUID id, Integer revisionId) {
        DataSetList dataSetList = this.modelsProvider.getDataSetListById(id);
        if (dataSetList != null) {
            ImmutableMap properties = ImmutableMap.of((Object)"RestoredTo", (Object)revisionId.toString());
            this.commitWithProperties(dataSetList, (Map<String, String>)properties);
        }
    }

    @Override
    public void deleteDataSetList(UUID id) {
        this.javersCommitService.commitShallowDeleteById((GlobalIdDTO)InstanceIdDTO.instanceId((Object)id, DataSetListSnapshot.class));
    }

    @Override
    public DataSetListSnapshot findDataSetListSnapshot(UUID id, Integer revisionId) {
        JqlQuery query = QueryBuilder.byInstanceId((Object)id, DataSetListSnapshot.class).withVersion((long)revisionId.intValue()).build();
        Object result = ((Shadow)this.javers.findShadows(query).stream().findFirst().orElseThrow(DataSetListIdNotFound::new)).get();
        return (DataSetListSnapshot)result;
    }

    private void commitWithProperties(DataSetList dsl, Map<String, String> properties) {
        log.debug("Preparing DataSetList for commit: {}", (Object)dsl.getId());
        DataSetListSnapshot dataSetListSnapshot = new DataSetListSnapshot(dsl);
        this.javersCommitService.commitWithExtraProperties(dataSetListSnapshot, properties);
        log.debug("Snapshot of DataSetList committed: {}", (Object)dataSetListSnapshot);
    }

    public DataSetListSnapshotServiceImpl(ModelsProvider modelsProvider, JaversCommitService javersCommitService, Javers javers) {
        this.modelsProvider = modelsProvider;
        this.javersCommitService = javersCommitService;
        this.javers = javers;
    }
}

