/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.impl;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.dataset.versioning.service.JaversAuthorProvider;

public class JaversAuthorProviderImpl
implements JaversAuthorProvider {
    private static final String UNAUTHENTICATED = "unauthenticated";
    private final Provider<UserInfo> userInfoProvider;

    public JaversAuthorProviderImpl(Provider<UserInfo> userInfoProvider) {
        this.userInfoProvider = userInfoProvider;
    }

    public String provide() {
        String name = UNAUTHENTICATED;
        UserInfo userInfo = (UserInfo)this.userInfoProvider.get();
        if (!Objects.isNull(userInfo)) {
            String fullName = userInfo.getFullName();
            name = StringUtils.isNotEmpty((CharSequence)fullName) ? fullName : userInfo.getUsername();
            name = name == null ? "" : name;
        }
        return name;
    }

    @Override
    public String getUsername() {
        UserInfo userInfo = (UserInfo)this.userInfoProvider.get();
        return Objects.nonNull(userInfo) ? userInfo.getUsername() : UNAUTHENTICATED;
    }
}

