/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.javers.core.Javers;
import org.javers.core.commit.Commit;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.InstanceIdDTO;
import org.qubership.atp.dataset.versioning.model.domain.DataSetListSnapshot;
import org.qubership.atp.dataset.versioning.service.JaversAuthorProvider;
import org.qubership.atp.dataset.versioning.service.JaversCommitService;
import org.springframework.stereotype.Service;

@Service
public class JaversCommitServiceImpl
implements JaversCommitService {
    private static final String USERNAME_PROPERTY_NAME = "Username";
    private final Javers javers;
    private final JaversAuthorProvider authorProvider;

    @Override
    public Commit commit(Object currentVersion) {
        return this.javers.commit(this.getAuthor(), currentVersion, this.getCommitProperties());
    }

    @Override
    public Commit commitWithExtraProperties(Object currentVersion, Map<String, String> extraProperties) {
        Map<String, String> commitProperties = this.getCommitProperties();
        commitProperties.putAll(extraProperties);
        return this.javers.commit(this.getAuthor(), currentVersion, commitProperties);
    }

    @Override
    public CompletableFuture<Commit> commitAsync(Object currentVersion, Executor executor) {
        return this.javers.commitAsync(this.getAuthor(), currentVersion, this.getCommitProperties(), executor);
    }

    @Override
    public Commit commitShallowDelete(Object deleted) {
        DataSetListSnapshot obj = (DataSetListSnapshot)deleted;
        Optional latestSnapshot = this.javers.getLatestSnapshot((Object)obj.getId(), DataSetListSnapshot.class);
        return latestSnapshot.map(cdoSnapshot -> this.javers.commitShallowDelete(this.getAuthor(), deleted, this.getCommitProperties())).orElse(null);
    }

    @Override
    public Commit commitShallowDeleteById(GlobalIdDTO globalId) {
        InstanceIdDTO instanceId = (InstanceIdDTO)globalId;
        Optional latestSnapshot = this.javers.getLatestSnapshot(instanceId.getCdoId(), instanceId.getEntity());
        return latestSnapshot.map(cdoSnapshot -> this.javers.commitShallowDeleteById(this.getAuthor(), globalId, this.getCommitProperties())).orElse(null);
    }

    private String getAuthor() {
        return this.authorProvider.provide();
    }

    private Map<String, String> getCommitProperties() {
        HashMap<String, String> commitProperties = new HashMap<String, String>();
        commitProperties.put(USERNAME_PROPERTY_NAME, this.authorProvider.getUsername());
        return commitProperties;
    }

    public JaversCommitServiceImpl(Javers javers, JaversAuthorProvider authorProvider) {
        this.javers = javers;
        this.authorProvider = authorProvider;
    }
}

