/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.impl;

import com.google.common.base.Preconditions;
import java.sql.Timestamp;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.util.Strings;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.service.direct.ClearCacheService;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.delegates.ListValue;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.delegates.VisibilityArea;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.versioning.exception.RestoredReferenceInvalidException;
import org.qubership.atp.dataset.versioning.model.domain.AttributeKeySnapshot;
import org.qubership.atp.dataset.versioning.model.domain.AttributeSnapshot;
import org.qubership.atp.dataset.versioning.model.domain.DataSetListSnapshot;
import org.qubership.atp.dataset.versioning.model.domain.DataSetSnapshot;
import org.qubership.atp.dataset.versioning.model.domain.ListValueSnapshot;
import org.qubership.atp.dataset.versioning.model.domain.ParameterSnapshot;
import org.qubership.atp.dataset.versioning.service.DataSetListSnapshotService;
import org.qubership.atp.dataset.versioning.service.RestoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RestoreServiceImpl
implements RestoreService {
    private static final Logger log = LoggerFactory.getLogger(RestoreServiceImpl.class);
    private final Provider<UserInfo> userInfoProvider;
    private final DataSetListSnapshotService snapshotService;
    private final ModelsProvider modelsProvider;
    private final ClearCacheService clearCacheService;
    private static final ZoneId UTC = ZoneId.of("UTC");

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void restore(UUID id, Integer revisionId) {
        log.debug("Starting restore DSL with id = {} and revision = {}", (Object)id, (Object)revisionId);
        DataSetListSnapshot dataSetListJ = this.snapshotService.findDataSetListSnapshot(id, revisionId);
        this.validateDataSetListIsLockedAnyDataSet(dataSetListJ);
        this.validateDataSetList(dataSetListJ);
        this.restoreDataSetList(dataSetListJ);
        this.snapshotService.findAndCommitRestored(id, revisionId);
        log.debug("Restored DLS with id = {} and revision = {}", (Object)id, (Object)revisionId);
    }

    private void validateDataSetListIsLockedAnyDataSet(DataSetListSnapshot dataSetListSnapshot) {
        UUID dslId = dataSetListSnapshot.getId();
        List<DataSet> dataSets = this.modelsProvider.getDataSetByDataSetListId(dslId);
        if (!dataSets.isEmpty()) {
            for (DataSet dataSet : dataSets) {
                Preconditions.checkArgument((!dataSet.isLocked() ? 1 : 0) != 0, (String)"Can not restore DSL '%s' with id : %s , because dataSet '%s' with id : %s is locked", (Object)dataSetListSnapshot.getName(), (Object)dataSetListSnapshot.getId(), (Object)dataSet.getName(), (Object)dataSet.getId());
            }
        }
    }

    private void validateDataSetList(DataSetListSnapshot dataSetListSnapshot) {
        LinkedList<String> violations = new LinkedList<String>();
        for (AttributeSnapshot attribute : dataSetListSnapshot.getAttributes()) {
            Object dataSetListById;
            if (AttributeTypeName.DSL.equals((Object)attribute.getType())) {
                dataSetListById = this.modelsProvider.getDataSetListById(attribute.getDataSetListReference());
                if (dataSetListById == null) {
                    violations.add(String.format("Data Set List reference '%s' not found", attribute.getDataSetListReference()));
                } else {
                    for (ParameterSnapshot parameter : attribute.getParameters()) {
                        DataSet dataSetById;
                        UUID parameterId = parameter.getDataSetReference();
                        if (!Objects.nonNull(parameterId) || (dataSetById = this.modelsProvider.getDataSetById(parameterId)) != null) continue;
                        violations.add(String.format("Data Set List reference '%s' not found", attribute.getDataSetListReference()));
                    }
                }
            }
            if (!AttributeTypeName.CHANGE.equals((Object)attribute.getType())) continue;
            dataSetListById = this.modelsProvider.getDataSetListById(attribute.getDataSetListReference());
            if (dataSetListById == null) {
                violations.add(String.format("Data Set List reference '%s' not found", attribute.getDataSetListReference()));
                continue;
            }
            for (ParameterSnapshot parameter : attribute.getParameters()) {
                String textValue = parameter.getText();
                List<UUID> dataSetUuids = this.extractDataSetsUuids(textValue);
                for (UUID dataSetId : dataSetUuids) {
                    DataSet dataSet = this.modelsProvider.getDataSetById(dataSetId);
                    if (dataSet != null) continue;
                    violations.add(String.format("Data Set reference '%s' not found", dataSetId));
                }
            }
        }
        for (AttributeKeySnapshot overlap : dataSetListSnapshot.getOverlaps()) {
            for (UUID attributeId : overlap.getAttributePath().subList(1, overlap.getAttributePath().size())) {
                if (this.modelsProvider.getAttributeById(attributeId) != null) continue;
                violations.add(String.format("Attribute '%s' not found", attributeId));
            }
            UUID attributeId = overlap.getAttributeId();
            if (this.modelsProvider.getAttributeById(attributeId) != null) continue;
            violations.add(String.format("Attribute '%s' not found", attributeId));
        }
        if (!violations.isEmpty()) {
            log.error("Validation failed for DataSetListJ: {}. Violations: {}", (Object)dataSetListSnapshot, violations);
            throw new RestoredReferenceInvalidException(violations);
        }
    }

    private void restoreDataSetList(DataSetListSnapshot targetSnapshot) {
        UUID dataSetListId = targetSnapshot.getId();
        DataSetList dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        Timestamp modified = new Timestamp(Instant.now(Clock.system(UTC)).toEpochMilli());
        if (dataSetList == null) {
            this.insertDataSetList(targetSnapshot, userId, modified);
            dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
        } else {
            this.updateSimpleDataSetListFields(targetSnapshot, dataSetList, userId, modified);
        }
        DataSetListSnapshot currentSnapshot = new DataSetListSnapshot(dataSetList);
        this.updateDataSets(currentSnapshot, targetSnapshot);
        this.updateAttributes(currentSnapshot, targetSnapshot);
        this.updateOverlaps(currentSnapshot, targetSnapshot);
    }

    private void updateOverlaps(DataSetListSnapshot currentSnapshot, DataSetListSnapshot targetSnapshot) {
        this.updateExistingOverlaps(currentSnapshot, targetSnapshot);
        this.createDeletedOverlaps(currentSnapshot, targetSnapshot);
        this.deleteCreatedOverlaps(currentSnapshot, targetSnapshot);
    }

    private void createDeletedOverlaps(DataSetListSnapshot currentSnapshot, DataSetListSnapshot targetSnapshot) {
        Set<UUID> missingOverlaps = this.getMissing(currentSnapshot.getOverlapsIds(), targetSnapshot.getOverlapsIds());
        for (UUID missingOverlapId : missingOverlaps) {
            AttributeKeySnapshot missingOverlap = targetSnapshot.getOverlapById(missingOverlapId);
            this.insertOverlap(currentSnapshot.getId(), missingOverlap);
        }
    }

    private void deleteCreatedOverlaps(DataSetListSnapshot currentSnapshot, DataSetListSnapshot targetSnapshot) {
        Set<UUID> overlapsToDelete = this.getExcessive(currentSnapshot.getOverlapsIds(), targetSnapshot.getOverlapsIds());
        for (UUID overlapToDelete : overlapsToDelete) {
            this.modelsProvider.getAttributeKeyById(overlapToDelete).remove();
        }
    }

    private void updateExistingOverlaps(DataSetListSnapshot currentSnapshot, DataSetListSnapshot targetSnapshot) {
        Set<UUID> commonOverlaps = this.getIntersection(currentSnapshot.getOverlapsIds(), targetSnapshot.getOverlapsIds());
        for (UUID commonOverlapId : commonOverlaps) {
            AttributeKeySnapshot currentOverlap = currentSnapshot.getOverlapById(commonOverlapId);
            AttributeKeySnapshot targetOverlap = targetSnapshot.getOverlapById(commonOverlapId);
            ParameterSnapshot targetParameter = targetOverlap.getParameter();
            if (currentOverlap.getParameter().equals(targetParameter)) continue;
            Parameter parameter = this.modelsProvider.getParameterById(currentOverlap.getParameter().getId());
            parameter.setId(targetParameter.getId());
            parameter.setStringValue(targetParameter.getText());
            parameter.setListValueId(targetParameter.getListValueId());
            parameter.setDataSetReferenceId(targetParameter.getDataSetReference());
            this.clearCacheService.evictParameterCache(parameter.getId());
        }
    }

    private void updateDataSets(DataSetListSnapshot currentSnapshot, DataSetListSnapshot targetSnapshot) {
        this.updateExistingDataSets(currentSnapshot, targetSnapshot);
        this.deleteCreatedDataSets(currentSnapshot, targetSnapshot);
        this.createDeletedDataSets(currentSnapshot, targetSnapshot);
    }

    private void updateAttributes(DataSetListSnapshot currentSnapshot, DataSetListSnapshot targetSnapshot) {
        this.updateExistingAttributes(currentSnapshot, targetSnapshot);
        this.deleteCreatedAttributes(currentSnapshot, targetSnapshot);
        this.createDeletedAttributes(currentSnapshot, targetSnapshot);
    }

    private void createDeletedDataSets(DataSetListSnapshot currentSnapshot, DataSetListSnapshot targetSnapshot) {
        Set<UUID> missingDataSets = this.getMissing(currentSnapshot.getDataSetsIds(), targetSnapshot.getDataSetsIds());
        for (UUID dataSetToCreate : missingDataSets) {
            DataSetSnapshot dataSetSnapshot = targetSnapshot.getDataSetById(dataSetToCreate);
            this.insertDataSet(targetSnapshot.getId(), dataSetSnapshot);
        }
    }

    private void deleteCreatedDataSets(DataSetListSnapshot currentSnapshot, DataSetListSnapshot targetSnapshot) {
        Set<UUID> dataSetsToDelete = this.getExcessive(currentSnapshot.getDataSetsIds(), targetSnapshot.getDataSetsIds());
        for (UUID dataSetToDelete : dataSetsToDelete) {
            this.modelsProvider.getDataSetById(dataSetToDelete).remove();
        }
    }

    private void updateExistingDataSets(DataSetListSnapshot currentSnapshot, DataSetListSnapshot targetSnapshot) {
        Set<UUID> commonDataSets = this.getIntersection(currentSnapshot.getDataSetsIds(), targetSnapshot.getDataSetsIds());
        currentSnapshot.getDataSetsIds().forEach(this.clearCacheService::evictDatasetListContextCache);
        for (UUID commonDataSetId : commonDataSets) {
            DataSetSnapshot targetDataSet;
            DataSetSnapshot currentDataSet = currentSnapshot.getDataSetById(commonDataSetId);
            if (currentDataSet.equals(targetDataSet = targetSnapshot.getDataSetById(commonDataSetId))) continue;
            DataSet dataSet = this.modelsProvider.getDataSetById(commonDataSetId);
            dataSet.setName(targetDataSet.getName());
            dataSet.setOrdering(targetDataSet.getOrdering());
            dataSet.setLocked(targetDataSet.getLocked());
        }
    }

    private Set<UUID> getIntersection(Set<UUID> current, Set<UUID> target) {
        HashSet<UUID> result = new HashSet<UUID>(target);
        result.retainAll(current);
        return result;
    }

    private Set<UUID> getExcessive(Set<UUID> current, Set<UUID> target) {
        HashSet<UUID> result = new HashSet<UUID>(current);
        result.removeAll(target);
        return result;
    }

    private Set<UUID> getMissing(Set<UUID> current, Set<UUID> target) {
        HashSet<UUID> result = new HashSet<UUID>(target);
        result.removeAll(current);
        return result;
    }

    private void updateExistingAttributes(DataSetListSnapshot currentVersion, DataSetListSnapshot targetVersion) {
        Set<UUID> commonAttributes = this.getIntersection(currentVersion.getAttributeIds(), targetVersion.getAttributeIds());
        for (UUID commonAttributeId : commonAttributes) {
            AttributeSnapshot currentAttribute = currentVersion.getAttributeById(commonAttributeId);
            AttributeSnapshot targetAttribute = targetVersion.getAttributeById(commonAttributeId);
            Attribute attribute = this.modelsProvider.getAttributeById(currentAttribute.getId());
            attribute.setName(targetAttribute.getName());
            attribute.setTypeDataSetListId(targetAttribute.getDataSetListReference());
            this.updateListValues(currentAttribute, targetAttribute);
            this.updateParameters(currentAttribute, targetAttribute);
        }
    }

    private void updateParameters(AttributeSnapshot currentAttribute, AttributeSnapshot targetAttribute) {
        currentAttribute.getParametersIds().forEach(this.clearCacheService::evictParameterCache);
        this.updateExistingParameters(currentAttribute, targetAttribute);
        this.deleteCreatedParameters(currentAttribute, targetAttribute);
        this.createDeletedParameters(currentAttribute, targetAttribute);
    }

    private void updateExistingParameters(AttributeSnapshot currentAttribute, AttributeSnapshot targetAttribute) {
        Set<UUID> commonParameters = this.getIntersection(currentAttribute.getParametersIds(), targetAttribute.getParametersIds());
        for (UUID commonParameter : commonParameters) {
            ParameterSnapshot targetParameter;
            ParameterSnapshot currentParameter = currentAttribute.getParameterById(commonParameter);
            if (currentParameter.equals(targetParameter = targetAttribute.getParameterById(commonParameter))) continue;
            Parameter parameter = this.modelsProvider.getParameterById(commonParameter);
            this.setValueByType(parameter, targetParameter, targetAttribute.getType());
        }
    }

    private void setValueByType(Parameter parameter, ParameterSnapshot targetParameter, AttributeTypeName typeName) {
        switch (typeName) {
            case CHANGE: 
            case ENCRYPTED: 
            case TEXT: {
                parameter.setStringValue(targetParameter.getText());
                break;
            }
            case LIST: {
                parameter.setListValueId(targetParameter.getListValueId());
                break;
            }
            case DSL: {
                parameter.setDataSetReferenceId(targetParameter.getDataSetReference());
                break;
            }
        }
    }

    private void createDeletedParameters(AttributeSnapshot currentAttribute, AttributeSnapshot targetAttribute) {
        Set<UUID> missingParameters = this.getMissing(currentAttribute.getParametersIds(), targetAttribute.getParametersIds());
        for (UUID targetParameter : missingParameters) {
            ParameterSnapshot parameter = targetAttribute.getParameterById(targetParameter);
            this.insertParameter(parameter, targetAttribute.getId());
        }
    }

    private void deleteCreatedParameters(AttributeSnapshot currentAttribute, AttributeSnapshot targetAttribute) {
        Set<UUID> parametersToDelete = this.getExcessive(currentAttribute.getParametersIds(), targetAttribute.getParametersIds());
        for (UUID parameterToDelete : parametersToDelete) {
            this.modelsProvider.getParameterById(parameterToDelete).remove();
        }
    }

    private void updateListValues(AttributeSnapshot currentAttribute, AttributeSnapshot targetAttribute) {
        this.updateExistingListValues(currentAttribute, targetAttribute);
        this.deleteCreatedListValues(currentAttribute, targetAttribute);
        this.createDeletedListValues(currentAttribute, targetAttribute);
    }

    private void createDeletedListValues(AttributeSnapshot currentAttribute, AttributeSnapshot targetAttribute) {
        Set<UUID> missingListValues = this.getMissing(currentAttribute.getListValuesIds(), targetAttribute.getListValuesIds());
        Attribute attribute = this.modelsProvider.getAttributeById(targetAttribute.getId());
        for (UUID missingListValueId : missingListValues) {
            ListValueSnapshot missingListValue = targetAttribute.getListValueById(missingListValueId);
            attribute.insertListValue(missingListValue.getId(), missingListValue.getName());
        }
    }

    private void deleteCreatedListValues(AttributeSnapshot currentAttribute, AttributeSnapshot targetAttribute) {
        Set<UUID> listValuesToDelete = this.getExcessive(currentAttribute.getListValuesIds(), targetAttribute.getListValuesIds());
        for (UUID listValueToDelete : listValuesToDelete) {
            this.modelsProvider.getListValueById(listValueToDelete).remove();
        }
    }

    private void updateExistingListValues(AttributeSnapshot currentAttribute, AttributeSnapshot targetAttribute) {
        Set<UUID> commonListValues = this.getIntersection(currentAttribute.getListValuesIds(), targetAttribute.getListValuesIds());
        for (UUID commonListValueId : commonListValues) {
            ListValueSnapshot targetListValue;
            ListValueSnapshot currentListValue = currentAttribute.getListValueById(commonListValueId);
            if (currentListValue.equals(targetListValue = targetAttribute.getListValueById(commonListValueId))) continue;
            ListValue listValue = this.modelsProvider.getListValueById(commonListValueId);
            listValue.setText(targetListValue.getName());
        }
    }

    private void createDeletedAttributes(DataSetListSnapshot currentVersion, DataSetListSnapshot targetVersion) {
        Set<UUID> missingAttributes = this.getMissing(currentVersion.getAttributeIds(), targetVersion.getAttributeIds());
        for (UUID missingAttributeId : missingAttributes) {
            AttributeSnapshot attribute = targetVersion.getAttributeById(missingAttributeId);
            this.insertAttribute(attribute, currentVersion.getId());
            for (ParameterSnapshot parameter : attribute.getParameters()) {
                this.insertParameter(parameter, attribute.getId());
            }
        }
    }

    private void deleteCreatedAttributes(DataSetListSnapshot currentVersion, DataSetListSnapshot targetVersion) {
        Set<UUID> attributesToDelete = this.getExcessive(currentVersion.getAttributeIds(), targetVersion.getAttributeIds());
        for (UUID currentAttribute : attributesToDelete) {
            this.modelsProvider.getAttributeById(currentAttribute).remove();
        }
    }

    private void insertDataSetList(DataSetListSnapshot snapshot, UUID userId, Timestamp modified) {
        VisibilityArea visibilityArea = this.modelsProvider.getVisibilityAreaById(snapshot.getVisibilityAreaId());
        DataSetList dataSetList = visibilityArea.insertDataSetList(snapshot.getId(), snapshot.getName());
        dataSetList.setModifiedBy(userId);
        dataSetList.setModifiedWhen(new Timestamp(modified.getTime()));
    }

    private void updateSimpleDataSetListFields(DataSetListSnapshot dataSetListJ, DataSetList dataSetList, UUID userId, Timestamp modified) {
        dataSetList.setModifiedBy(userId);
        dataSetList.setModifiedWhen(new Timestamp(modified.getTime()));
        dataSetList.setName(dataSetListJ.getName());
        dataSetList.save();
    }

    private void insertAttribute(AttributeSnapshot attributeSnapshot, UUID dataSetListId) {
        DataSetList dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
        Attribute attribute = dataSetList.insertAttribute(attributeSnapshot.getId(), attributeSnapshot.getName(), attributeSnapshot.getType(), attributeSnapshot.getOrdering());
        attribute.setTypeDataSetListId(attributeSnapshot.getDataSetListReference());
        for (ListValueSnapshot listValue : attributeSnapshot.getListValues()) {
            attribute.insertListValue(listValue.getId(), listValue.getName());
        }
    }

    private void insertParameter(ParameterSnapshot parameterSnapshot, UUID attributeId) {
        DataSet dataSet = this.modelsProvider.getDataSetById(parameterSnapshot.getDataSetId());
        Parameter parameter = dataSet.insertParameter(parameterSnapshot.getId(), attributeId);
        parameter.setStringValue(parameterSnapshot.getText());
        if (Objects.nonNull(parameterSnapshot.getDataSetReference())) {
            parameter.setStringValue(null);
            parameter.setDataSetReferenceId(parameterSnapshot.getDataSetReference());
        }
        parameter.setListValueId(parameterSnapshot.getListValueId());
    }

    private void insertDataSet(UUID dataSetListId, DataSetSnapshot dataSetSnapshot) {
        DataSetList dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
        DataSet dataSet = dataSetList.insertDataSet(dataSetSnapshot.getId(), dataSetSnapshot.getName());
        dataSet.setOrdering(dataSetSnapshot.getOrdering());
    }

    private void insertOverlap(UUID dataSetListId, AttributeKeySnapshot missingOverlap) {
        DataSetList dataSetList = this.modelsProvider.getDataSetListById(dataSetListId);
        ParameterSnapshot targetParameter = missingOverlap.getParameter();
        Parameter parameter = dataSetList.insertOverlap(missingOverlap.getDataSetId(), missingOverlap.getId(), missingOverlap.getAttributeId(), missingOverlap.getAttributePath(), targetParameter.getId());
        parameter.setStringValue(targetParameter.getText());
        parameter.setListValueId(targetParameter.getListValueId());
        parameter.setDataSetReferenceId(targetParameter.getDataSetReference());
    }

    private List<UUID> extractDataSetsUuids(String textValue) {
        if (Strings.isEmpty((CharSequence)textValue)) {
            return Collections.emptyList();
        }
        try {
            String[] split = textValue.replaceFirst("MULTIPLY ", "").split(" ");
            LinkedList<UUID> result = new LinkedList<UUID>();
            for (String uuidString : split) {
                result.add(UUID.fromString(uuidString));
            }
            return result;
        }
        catch (Exception e) {
            log.info("Error parsing multiple parameter '{}'", (Object)textValue, (Object)e);
            return Collections.emptyList();
        }
    }

    public RestoreServiceImpl(Provider<UserInfo> userInfoProvider, DataSetListSnapshotService snapshotService, ModelsProvider modelsProvider, ClearCacheService clearCacheService) {
        this.userInfoProvider = userInfoProvider;
        this.snapshotService = snapshotService;
        this.modelsProvider = modelsProvider;
        this.clearCacheService = clearCacheService;
    }
}

