/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.changetype;

import java.util.Objects;
import java.util.Optional;
import org.javers.common.string.PrettyValuePrinter;
import org.javers.common.validation.Validate;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.changetype.PropertyChangeMetadata;
import org.javers.core.metamodel.object.GlobalId;

public class ReferenceChange
extends PropertyChange {
    private final GlobalId left;
    private final GlobalId right;
    private final transient Optional<Object> leftObject;
    private final transient Optional<Object> rightObject;

    public ReferenceChange(PropertyChangeMetadata metadata, GlobalId leftReference, GlobalId rightReference, Object leftObject, Object rightObject) {
        super(metadata);
        this.left = leftReference;
        this.right = rightReference;
        this.leftObject = Optional.ofNullable(leftObject);
        this.rightObject = Optional.ofNullable(rightObject);
    }

    public GlobalId getLeft() {
        return this.left;
    }

    public GlobalId getRight() {
        return this.right;
    }

    public Optional<Object> getLeftObject() {
        return this.leftObject;
    }

    public Optional<Object> getRightObject() {
        return this.rightObject;
    }

    @Override
    public String prettyPrint(PrettyValuePrinter valuePrinter) {
        Validate.argumentIsNotNull(valuePrinter);
        if (this.isPropertyAdded()) {
            return valuePrinter.formatWithQuotes(this.getPropertyNameWithPath()) + " property with reference " + valuePrinter.formatWithQuotes(this.getRight()) + " added";
        }
        if (this.isPropertyRemoved()) {
            return valuePrinter.formatWithQuotes(this.getPropertyNameWithPath()) + " property with reference " + valuePrinter.formatWithQuotes(this.getLeft()) + " removed";
        }
        if (this.left == null) {
            return valuePrinter.formatWithQuotes(this.getPropertyNameWithPath()) + " = " + valuePrinter.formatWithQuotes(this.getRight());
        }
        if (this.right == null) {
            return valuePrinter.formatWithQuotes(this.getPropertyNameWithPath()) + " reference " + valuePrinter.formatWithQuotes(this.getLeft()) + " unset";
        }
        return valuePrinter.formatWithQuotes(this.getPropertyNameWithPath()) + " reference changed: " + valuePrinter.formatWithQuotes(this.getLeft()) + " -> " + valuePrinter.formatWithQuotes(this.getRight());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ReferenceChange) {
            ReferenceChange that = (ReferenceChange)obj;
            return super.equals(that) && Objects.equals(this.getLeft(), that.getLeft()) && Objects.equals(this.getRight(), that.getRight());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getLeft(), this.getRight());
    }

    @Override
    public String toString() {
        PrettyValuePrinter valuePrinter = PrettyValuePrinter.getDefault();
        return this.getClass().getSimpleName() + "{ property: '" + this.getPropertyName() + "', left:" + valuePrinter.formatWithQuotes(this.getLeft()) + ",  right:" + valuePrinter.formatWithQuotes(this.getRight()) + " }";
    }
}

