/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.scanner;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.javers.common.reflection.JaversMember;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.scanner.AnnotationNamesProvider;
import org.javers.core.metamodel.scanner.PropertyScan;

abstract class PropertyScanner {
    private final AnnotationNamesProvider annotationNamesProvider;

    PropertyScanner(AnnotationNamesProvider annotationNamesProvider) {
        this.annotationNamesProvider = annotationNamesProvider;
    }

    public PropertyScan scan(Class<?> managedClass, boolean ignoreDeclaredProperties) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (JaversMember member : this.getMembers(managedClass)) {
            boolean isIgnoredInType = ignoreDeclaredProperties && member.getDeclaringClass().equals(managedClass);
            boolean hasTransientAnn = this.annotationNamesProvider.hasTransientPropertyAnn(member.getAnnotationTypes());
            boolean hasShallowReferenceAnn = this.annotationNamesProvider.hasShallowReferenceAnn(member.getAnnotationTypes());
            boolean hasIncludeAnn = this.annotationNamesProvider.hasDiffIncludeAnn(member.getAnnotationTypes());
            Optional<String> customPropertyName = this.annotationNamesProvider.findPropertyNameAnnValue(member.getAnnotations());
            properties.add(new Property(member, hasTransientAnn || isIgnoredInType, hasShallowReferenceAnn, customPropertyName, hasIncludeAnn));
        }
        return new PropertyScan(properties);
    }

    abstract List<JaversMember> getMembers(Class<?> var1);

    public PropertyScan scan(Class<?> managedClass) {
        return this.scan(managedClass, false);
    }
}

