/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.ManagedClass;
import org.javers.core.metamodel.type.ManagedPropertiesFilter;
import org.javers.core.metamodel.type.ManagedType;

public class ValueObjectType
extends ManagedType {
    private final boolean defaultType;
    private final Optional<Function<Object, String>> toStringFunction = Optional.empty();

    ValueObjectType(ManagedClass valueObject) {
        super(valueObject);
        this.defaultType = false;
    }

    public ValueObjectType(Class baseJavaClass, List<JaversProperty> allProperties) {
        this(new ManagedClass(baseJavaClass, allProperties, Collections.emptyList(), ManagedPropertiesFilter.empty()));
    }

    ValueObjectType(ManagedClass valueObject, Optional<String> typeName, boolean isDefault) {
        super(valueObject, typeName);
        this.defaultType = isDefault;
    }

    @Override
    ValueObjectType spawn(ManagedClass managedClass, Optional<String> typeName) {
        return new ValueObjectType(managedClass, typeName, this.defaultType);
    }

    @Override
    public boolean canBePrototype() {
        return !this.defaultType;
    }

    public String smartToString(Object value) {
        if (value == null) {
            return "";
        }
        return this.toStringFunction.map(f -> (String)f.apply(value)).orElse(ReflectionUtil.reflectiveToString(value));
    }
}

