/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractCppCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;

public class CppUE4ClientCodegen
extends AbstractCppCodegen {
    public static final String CPP_NAMESPACE = "cppNamespace";
    public static final String CPP_NAMESPACE_DESC = "C++ namespace (convention: name::space::for::api).";
    public static final String UNREAL_MODULE_NAME = "unrealModuleName";
    public static final String UNREAL_MODULE_NAME_DESC = "Name of the generated unreal module (optional)";
    public static final String OPTIONAL_PROJECT_FILE_DESC = "Generate Build.cs";
    protected String unrealModuleName = "OpenAPI";
    protected Set<String> pointerClasses = new HashSet<String>();
    protected String privateFolder = "Private";
    protected String publicFolder = "Public";
    protected String apiVersion = "1.0.0";
    protected Map<String, String> namespaces = new HashMap<String, String>();
    protected Set<String> systemIncludes = new HashSet<String>();
    protected String cppNamespace = this.unrealModuleName;
    protected boolean optionalProjectFileFlag = true;

    public CppUE4ClientCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.outputFolder = "generated-code/cpp-ue4";
        if ("".equals(this.modelNamePrefix)) {
            this.modelNamePrefix = this.unrealModuleName;
        }
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-source.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-source.mustache", ".cpp");
        this.apiTemplateFiles.put("api-operations-header.mustache", ".h");
        this.apiTemplateFiles.put("api-operations-source.mustache", ".cpp");
        this.templateDir = "cpp-ue4";
        this.embeddedTemplateDir = "cpp-ue4";
        this.addOption(CPP_NAMESPACE, CPP_NAMESPACE_DESC, this.cppNamespace);
        this.addOption(UNREAL_MODULE_NAME, UNREAL_MODULE_NAME_DESC, this.unrealModuleName);
        this.addSwitch("optionalProjectFile", OPTIONAL_PROJECT_FILE_DESC, this.optionalProjectFileFlag);
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties().put("modelNamePrefix", this.modelNamePrefix);
        this.additionalProperties().put("modelPackage", this.modelPackage);
        this.additionalProperties().put("apiPackage", this.apiPackage);
        this.additionalProperties().put("dllapi", this.unrealModuleName.toUpperCase(Locale.ROOT) + "_API");
        this.additionalProperties().put(UNREAL_MODULE_NAME, this.unrealModuleName);
        this.additionalProperties.put(CPP_NAMESPACE, this.cppNamespace);
        this.additionalProperties.put(UNREAL_MODULE_NAME, this.unrealModuleName);
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "int32", "int64", "float", "double", "FString", "FDateTime", "FGuid", "TArray", "TArray<uint8>", "TMap", "TSet", "TSharedPtr<FJsonObject>", "TSharedPtr<FJsonValue>"));
        this.supportingFiles.add(new SupportingFile("model-base-header.mustache", this.publicFolder, this.modelNamePrefix + "BaseModel.h"));
        this.supportingFiles.add(new SupportingFile("model-base-source.mustache", this.privateFolder, this.modelNamePrefix + "BaseModel.cpp"));
        this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.publicFolder, this.modelNamePrefix + "Helpers.h"));
        this.supportingFiles.add(new SupportingFile("helpers-source.mustache", this.privateFolder, this.modelNamePrefix + "Helpers.cpp"));
        if (this.optionalProjectFileFlag) {
            this.supportingFiles.add(new SupportingFile("Build.cs.mustache", this.unrealModuleName + ".Build.cs"));
            this.supportingFiles.add(new SupportingFile("module-header.mustache", this.privateFolder, this.unrealModuleName + "Module.h"));
            this.supportingFiles.add(new SupportingFile("module-source.mustache", this.privateFolder, this.unrealModuleName + "Module.cpp"));
        }
        this.typeMapping = new HashMap();
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int32");
        this.typeMapping.put("long", "int64");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("number", "double");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("string", "FString");
        this.typeMapping.put("byte", "uint8");
        this.typeMapping.put("binary", "TArray<uint8>");
        this.typeMapping.put("ByteArray", "TArray<uint8>");
        this.typeMapping.put("password", "FString");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("date", "FDateTime");
        this.typeMapping.put("Date", "FDateTime");
        this.typeMapping.put("date-time", "FDateTime");
        this.typeMapping.put("DateTime", "FDateTime");
        this.typeMapping.put("array", "TArray");
        this.typeMapping.put("set", "TSet");
        this.typeMapping.put("list", "TArray");
        this.typeMapping.put("map", "TMap");
        this.typeMapping.put("object", "TSharedPtr<FJsonObject>");
        this.typeMapping.put("Object", "TSharedPtr<FJsonObject>");
        this.typeMapping.put("file", "HttpFileInput");
        this.typeMapping.put("UUID", "FGuid");
        this.typeMapping.put("AnyType", "TSharedPtr<FJsonValue>");
        this.importMapping = new HashMap();
        this.importMapping.put("HttpFileInput", "#include \"" + this.modelNamePrefix + "Helpers.h\"");
        this.namespaces = new HashMap<String, String>();
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(CPP_NAMESPACE)) {
            this.cppNamespace = (String)this.additionalProperties.get(CPP_NAMESPACE);
        }
        this.additionalProperties.put("cppNamespaceDeclarations", this.cppNamespace.split("\\::"));
        boolean updateSupportingFiles = false;
        if (this.additionalProperties.containsKey(UNREAL_MODULE_NAME)) {
            this.unrealModuleName = (String)this.additionalProperties.get(UNREAL_MODULE_NAME);
            this.additionalProperties().put("dllapi", this.unrealModuleName.toUpperCase(Locale.ROOT) + "_API");
            this.modelNamePrefix = this.unrealModuleName;
            updateSupportingFiles = true;
        }
        if (this.additionalProperties.containsKey("modelNamePrefix")) {
            this.modelNamePrefix = (String)this.additionalProperties.get("modelNamePrefix");
            updateSupportingFiles = true;
        }
        if (this.additionalProperties.containsKey("optionalProjectFile")) {
            this.setOptionalProjectFileFlag(this.convertPropertyToBooleanAndWriteBack("optionalProjectFile"));
        } else {
            this.additionalProperties.put("optionalProjectFile", this.optionalProjectFileFlag);
        }
        if (updateSupportingFiles) {
            this.supportingFiles.clear();
            this.supportingFiles.add(new SupportingFile("model-base-header.mustache", this.publicFolder, this.modelNamePrefix + "BaseModel.h"));
            this.supportingFiles.add(new SupportingFile("model-base-source.mustache", this.privateFolder, this.modelNamePrefix + "BaseModel.cpp"));
            this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.publicFolder, this.modelNamePrefix + "Helpers.h"));
            this.supportingFiles.add(new SupportingFile("helpers-source.mustache", this.privateFolder, this.modelNamePrefix + "Helpers.cpp"));
            if (this.optionalProjectFileFlag) {
                this.supportingFiles.add(new SupportingFile("Build.cs.mustache", this.unrealModuleName + ".Build.cs"));
                this.supportingFiles.add(new SupportingFile("module-header.mustache", this.privateFolder, this.unrealModuleName + "Module.h"));
                this.supportingFiles.add(new SupportingFile("module-source.mustache", this.privateFolder, this.unrealModuleName + "Module.cpp"));
            }
            this.importMapping.put("HttpFileInput", "#include \"" + this.modelNamePrefix + "Helpers.h\"");
        }
    }

    public void setOptionalProjectFileFlag(boolean flag) {
        this.optionalProjectFileFlag = flag;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "cpp-ue4";
    }

    @Override
    public String getHelp() {
        return "Generates a Unreal Engine 4 C++ Module (beta).";
    }

    @Override
    public String toModelImport(String name) {
        if (this.namespaces.containsKey(name)) {
            return "using " + this.namespaces.get(name) + ";";
        }
        if (this.systemIncludes.contains(name)) {
            return "#include <" + name + ">";
        }
        String folder = this.modelPackage().replace("::", File.separator);
        if (!folder.isEmpty()) {
            folder = folder + File.separator;
        }
        return "#include \"" + folder + name + ".h\"";
    }

    @Override
    protected boolean needToImport(String type) {
        boolean shouldImport = super.needToImport(type);
        if (shouldImport) {
            return !this.languageSpecificPrimitives.contains(type);
        }
        return false;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.modelPackage().replace("::", File.separator);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace("::", File.separator);
    }

    @Override
    public String modelFilename(String templateName, String modelName) {
        String suffix = this.modelTemplateFiles().get(templateName);
        String folder = this.privateFolder;
        if (".h".equals(suffix)) {
            folder = this.publicFolder;
        }
        return this.modelFileFolder() + File.separator + folder + File.separator + this.toModelFilename(modelName) + suffix;
    }

    @Override
    public String toModelFilename(String name) {
        name = this.sanitizeName(name);
        return this.modelNamePrefix + StringUtils.camelize(name);
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String suffix = this.apiTemplateFiles().get(templateName);
        String folder = this.privateFolder;
        if (".h".equals(suffix)) {
            folder = this.publicFolder;
        }
        if (templateName.startsWith("api-operations")) {
            return this.apiFileFolder() + File.separator + folder + File.separator + this.toApiFilename(tag) + "Operations" + suffix;
        }
        return this.apiFileFolder() + File.separator + folder + File.separator + this.toApiFilename(tag) + suffix;
    }

    @Override
    public String toApiFilename(String name) {
        name = this.sanitizeName(name);
        return this.modelNamePrefix + StringUtils.camelize(name) + "Api";
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        String openAPIType = this.getSchemaType(p);
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            return this.getSchemaType(p) + "<" + this.getTypeDeclaration(ap.getItems()) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            return this.getSchemaType(p) + "<FString, " + this.getTypeDeclaration(this.getAdditionalProperties(p)) + ">";
        }
        if (this.pointerClasses.contains(openAPIType)) {
            return openAPIType + "*";
        }
        if (this.languageSpecificPrimitives.contains(openAPIType)) {
            return this.toModelName(openAPIType);
        }
        return openAPIType;
    }

    @Override
    public String getTypeDeclaration(String name) {
        return name;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isStringSchema(p)) {
            if (p.getDefault() != null) {
                return "TEXT(\"" + p.getDefault().toString() + "\")";
            }
            return null;
        }
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return "false";
        }
        if (ModelUtils.isDateSchema(p)) {
            return "FDateTime(0)";
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            return "FDateTime(0)";
        }
        if (ModelUtils.isDoubleSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return "0.0";
        }
        if (ModelUtils.isFloatSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return "0.0f";
        }
        if (ModelUtils.isIntegerSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return "0";
        }
        if (ModelUtils.isLongSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return "0";
        }
        return null;
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
            if (this.pointerClasses.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toModelName(String type) {
        if (this.typeMapping.keySet().contains(type) || this.typeMapping.values().contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        return this.modelNamePrefix + StringUtils.camelize(this.sanitizeName(type));
    }

    @Override
    public String toVarName(String name) {
        String camelCaseName;
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            name = name.toLowerCase(Locale.ROOT);
        }
        if (!(camelCaseName = StringUtils.camelize(name)).isEmpty()) {
            name = camelCaseName;
        }
        if (this.isReservedWord(name) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        return this.toVarName(name);
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toApiName(String type) {
        return this.modelNamePrefix + StringUtils.camelize(type) + "Api";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String toBooleanGetter(String name) {
        return "Is" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String toGetter(String name) {
        return "Get" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String toSetter(String name) {
        return "Set" + this.getterAndSetterCapitalize(name);
    }
}

