/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.pactbroker;

import au.com.dius.pact.core.pactbroker.HalClient;
import au.com.dius.pact.core.pactbroker.IHalClient;
import au.com.dius.pact.core.pactbroker.InvalidHalResponse;
import au.com.dius.pact.core.pactbroker.InvalidNavigationRequest;
import au.com.dius.pact.core.pactbroker.NotFoundHalResponse;
import au.com.dius.pact.core.pactbroker.RequestFailedException;
import au.com.dius.pact.core.pactbroker.util.HttpClientUtils;
import au.com.dius.pact.core.support.HttpClient;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.JsonKt;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.core.support.json.JsonParser;
import au.com.dius.pact.core.support.json.JsonValue;
import au.com.dius.pact.core.support.json.JsonValueKt;
import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Ok;
import com.github.michaelbull.result.Result;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 ^2\u00020\u0001:\u0001^B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J.\u0010+\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u0003H\u0002J \u0010.\u001a\u0012\u0012\u0004\u0012\u00020%\u0012\b\u0012\u000600j\u0002`10/2\u0006\u00102\u001a\u00020\u0003H\u0016J(\u0010.\u001a\u0012\u0012\u0004\u0012\u00020%\u0012\b\u0012\u000600j\u0002`10/2\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u000204H\u0016J$\u00105\u001a\u00020%2\u0006\u00106\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J,\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00032\u001a\u0010:\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00050;H\u0016J \u0010<\u001a\u0012\u0012\u0004\u0012\u00020=\u0012\b\u0012\u000600j\u0002`10/2\u0006\u00102\u001a\u00020\u0003H\u0016J(\u0010<\u001a\u0012\u0012\u0004\u0012\u00020=\u0012\b\u0012\u000600j\u0002`10/2\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u000204H\u0016J6\u0010>\u001a\u0004\u0018\u00010\u00062\u0006\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010\u00032\u001a\u0010:\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060BJ(\u0010C\u001a\u0012\u0012\u0004\u0012\u00020=\u0012\b\u0012\u000600j\u0002`10/2\u0006\u0010D\u001a\u00020E2\u0006\u00102\u001a\u00020\u0003H\u0002J0\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002040G2\u0006\u00106\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0006\u0010H\u001a\u000208J\u001d\u0010I\u001a\u0002HJ\"\b\b\u0000\u0010J*\u00020K2\u0006\u0010L\u001a\u0002HJ\u00a2\u0006\u0002\u0010MJ\u0012\u0010N\u001a\u0004\u0018\u00010\u00032\u0006\u0010O\u001a\u00020\u0003H\u0016J\b\u0010P\u001a\u00020\u0001H\u0016J\u0010\u0010P\u001a\u00020\u00012\u0006\u00106\u001a\u00020\u0003H\u0016J$\u0010P\u001a\u00020\u00012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u00106\u001a\u00020\u0003H\u0016J\"\u0010Q\u001a\u00020\u00032\u0006\u0010R\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005J(\u0010S\u001a\u0012\u0012\u0004\u0012\u000204\u0012\b\u0012\u000600j\u0002`10/2\u0006\u0010T\u001a\u00020\u00032\u0006\u0010A\u001a\u00020\u0003H\u0016Jb\u0010S\u001a\u0012\u0012\u0004\u0012\u000204\u0012\b\u0012\u000600j\u0002`10/2\u0006\u0010T\u001a\u00020\u00032\u0006\u0010A\u001a\u00020\u000328\u0010U\u001a4\u0012\u0013\u0012\u00110!\u00a2\u0006\f\bW\u0012\b\bO\u0012\u0004\b\b(X\u0012\u0013\u0012\u00110E\u00a2\u0006\f\bW\u0012\b\bO\u0012\u0004\b\b(D\u0012\u0004\u0012\u000204\u0018\u00010VH\u0016J<\u0010S\u001a\u0012\u0012\u0004\u0012\u00020%\u0012\b\u0012\u000600j\u0002`10/2\u0006\u00106\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010Y\u001a\u00020\u0003H\u0016J<\u0010Z\u001a\u0012\u0012\u0004\u0012\u000204\u0012\b\u0012\u000600j\u0002`10/2\u0006\u00106\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010Y\u001a\u00020\u0003H\u0016J\b\u0010[\u001a\u00020\u0011H\u0016J\u0010\u0010\\\u001a\u00020\u00012\u0006\u0010]\u001a\u00020%H\u0016J\u001e\u0010\\\u001a\u00020\u00012\u0014\u0010]\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\t\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\r\"\u0004\b#\u0010\u000fR\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lau/com/dius/pact/core/pactbroker/HalClient;", "Lau/com/dius/pact/core/pactbroker/IHalClient;", "baseUrl", "", "options", "", "", "(Ljava/lang/String;Ljava/util/Map;)V", "getBaseUrl", "()Ljava/lang/String;", "defaultHeaders", "", "getDefaultHeaders", "()Ljava/util/Map;", "setDefaultHeaders", "(Ljava/util/Map;)V", "httpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "getHttpClient", "()Lorg/apache/http/impl/client/CloseableHttpClient;", "setHttpClient", "(Lorg/apache/http/impl/client/CloseableHttpClient;)V", "httpContext", "Lorg/apache/http/client/protocol/HttpClientContext;", "getHttpContext", "()Lorg/apache/http/client/protocol/HttpClientContext;", "setHttpContext", "(Lorg/apache/http/client/protocol/HttpClientContext;)V", "lastUrl", "getLastUrl", "setLastUrl", "(Ljava/lang/String;)V", "maxPublishRetries", "", "getOptions", "setOptions", "pathInfo", "Lau/com/dius/pact/core/support/json/JsonValue$Object;", "getPathInfo", "()Lau/com/dius/pact/core/support/json/JsonValue$Object;", "setPathInfo", "(Lau/com/dius/pact/core/support/json/JsonValue$Object;)V", "publishRetryInterval", "encodePathParameter", "key", "value", "fetch", "Lcom/github/michaelbull/result/Result;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "path", "encodePath", "", "fetchLink", "link", "forAll", "", "linkName", "closure", "Ljava/util/function/Consumer;", "getJson", "Lau/com/dius/pact/core/support/json/JsonValue;", "handleFailure", "resp", "Lorg/apache/http/HttpResponse;", "body", "Ljava/util/function/BiFunction;", "handleHalResponse", "response", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "hrefForLink", "Lkotlin/Pair;", "initPathInfo", "initialiseRequest", "Method", "Lorg/apache/http/HttpMessage;", "method", "(Lorg/apache/http/HttpMessage;)Lorg/apache/http/HttpMessage;", "linkUrl", "name", "navigate", "parseLinkUrl", "href", "postJson", "url", "handler", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "status", "json", "putJson", "setupHttpClient", "withDocContext", "docAttributes", "Companion", "pactbroker"})
public class HalClient
implements IHalClient {
    @Nullable
    private CloseableHttpClient httpClient;
    @Nullable
    private HttpClientContext httpContext;
    @Nullable
    private JsonValue.Object pathInfo;
    @Nullable
    private String lastUrl;
    @NotNull
    private Map<String, String> defaultHeaders;
    private int maxPublishRetries;
    private int publishRetryInterval;
    @NotNull
    private final String baseUrl;
    @NotNull
    private Map<String, ? extends Object> options;
    @NotNull
    public static final String ROOT = "/";
    @NotNull
    public static final String LINKS = "_links";
    @NotNull
    public static final String PREEMPTIVE_AUTHENTICATION = "pact.pactbroker.httpclient.usePreemptiveAuthentication";
    @NotNull
    private static final Regex URL_TEMPLATE_REGEX;
    public static final Companion Companion;

    @Nullable
    public final CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public final void setHttpClient(@Nullable CloseableHttpClient closeableHttpClient) {
        this.httpClient = closeableHttpClient;
    }

    @Nullable
    public final HttpClientContext getHttpContext() {
        return this.httpContext;
    }

    public final void setHttpContext(@Nullable HttpClientContext httpClientContext) {
        this.httpContext = httpClientContext;
    }

    @Nullable
    public final JsonValue.Object getPathInfo() {
        return this.pathInfo;
    }

    public final void setPathInfo(@Nullable JsonValue.Object object) {
        this.pathInfo = object;
    }

    @Nullable
    public final String getLastUrl() {
        return this.lastUrl;
    }

    public final void setLastUrl(@Nullable String string) {
        this.lastUrl = string;
    }

    @NotNull
    public final Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public final void setDefaultHeaders(@NotNull Map<String, String> map2) {
        Intrinsics.checkParameterIsNotNull(map2, (String)"<set-?>");
        this.defaultHeaders = map2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <Method extends HttpMessage> Method initialiseRequest(@NotNull Method method) {
        Intrinsics.checkParameterIsNotNull(method, (String)"method");
        Map<String, String> $this$forEach$iv = this.defaultHeaders;
        boolean $i$f$forEach = false;
        Map<String, String> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$key$value = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, String> entry = $dstr$key$value;
            boolean bl3 = false;
            String string = entry.getKey();
            entry = $dstr$key$value;
            bl3 = false;
            String value = entry.getValue();
            method.addHeader((String)key, value);
        }
        return method;
    }

    @Override
    @NotNull
    public Result<Boolean, Exception> postJson(@NotNull String url, @NotNull String body) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        return this.postJson(url, body, null);
    }

    @Override
    @NotNull
    public Result<Boolean, Exception> postJson(@NotNull String url, @NotNull String body, @Nullable Function2<? super Integer, ? super CloseableHttpResponse, Boolean> handler) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Companion.getLogger().debug((Function0)new Function0<String>(url, body){
            final /* synthetic */ String $url;
            final /* synthetic */ String $body;

            @NotNull
            public final String invoke() {
                return "Posting JSON to " + this.$url + '\n' + this.$body;
            }
            {
                this.$url = string;
                this.$body = string2;
                super(0);
            }
        });
        CloseableHttpClient client = this.setupHttpClient();
        return KotlinLanguageSupportKt.handleWith((Function0)((Function0)new Function0<Boolean>(this, url, body, client, handler){
            final /* synthetic */ HalClient this$0;
            final /* synthetic */ String $url;
            final /* synthetic */ String $body;
            final /* synthetic */ CloseableHttpClient $client;
            final /* synthetic */ Function2 $handler;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final boolean invoke() {
                boolean bl;
                HttpPost httpPost = (HttpPost)this.this$0.initialiseRequest((HttpMessage)new HttpPost(this.$url));
                httpPost.addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
                httpPost.setEntity((HttpEntity)new StringEntity(this.$body, ContentType.APPLICATION_JSON));
                Closeable closeable = (Closeable)this.$client.execute((HttpUriRequest)httpPost, (HttpContext)this.this$0.getHttpContext());
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    boolean bl3;
                    CloseableHttpResponse it = (CloseableHttpResponse)closeable;
                    boolean bl4 = false;
                    HalClient.Companion.getLogger().debug((Function0)new Function0<String>(it){
                        final /* synthetic */ CloseableHttpResponse $it;

                        @NotNull
                        public final String invoke() {
                            StringBuilder stringBuilder = new StringBuilder().append("Got response ");
                            CloseableHttpResponse closeableHttpResponse = this.$it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                            return stringBuilder.append(closeableHttpResponse.getStatusLine()).toString();
                        }
                        {
                            this.$it = closeableHttpResponse;
                            super(0);
                        }
                    });
                    HalClient.Companion.getLogger().debug((Function0)new Function0<String>(it){
                        final /* synthetic */ CloseableHttpResponse $it;

                        @NotNull
                        public final String invoke() {
                            String string;
                            StringBuilder stringBuilder = new StringBuilder().append("Response body: ");
                            CloseableHttpResponse closeableHttpResponse = this.$it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                            Object object = closeableHttpResponse.getEntity();
                            if (object != null && (object = object.getContent()) != null) {
                                Object object2 = object;
                                StringBuilder stringBuilder2 = stringBuilder;
                                Charset charset = Charsets.UTF_8;
                                boolean bl = false;
                                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object2, charset);
                                stringBuilder = stringBuilder2;
                                string = TextStreamsKt.readText((Reader)inputStreamReader);
                            } else {
                                string = null;
                            }
                            return stringBuilder.append(string).toString();
                        }
                        {
                            this.$it = closeableHttpResponse;
                            super(0);
                        }
                    });
                    if (this.$handler != null) {
                        CloseableHttpResponse closeableHttpResponse = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                        StatusLine statusLine = closeableHttpResponse.getStatusLine();
                        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"it.statusLine");
                        bl3 = (Boolean)this.$handler.invoke((Object)statusLine.getStatusCode(), (Object)it);
                    } else {
                        CloseableHttpResponse closeableHttpResponse = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                        StatusLine statusLine = closeableHttpResponse.getStatusLine();
                        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"it.statusLine");
                        bl3 = statusLine.getStatusCode() < 300;
                    }
                    bl = bl3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return bl;
            }
            {
                this.this$0 = halClient;
                this.$url = string;
                this.$body = string2;
                this.$client = closeableHttpClient;
                this.$handler = function2;
                super(0);
            }
        }));
    }

    @NotNull
    public CloseableHttpClient setupHttpClient() {
        if (this.httpClient == null) {
            if (this.options.containsKey("authentication") && !(this.options.get("authentication") instanceof List)) {
                HttpClient.INSTANCE.getLogger().warn((Function0)setupHttpClient.1.INSTANCE);
            }
            URI uri = new URI(this.baseUrl);
            Pair result = HttpClient.INSTANCE.newHttpClient(this.options.get("authentication"), uri, this.defaultHeaders, this.maxPublishRetries, this.publishRetryInterval);
            this.httpClient = (CloseableHttpClient)result.getFirst();
            if (Intrinsics.areEqual((Object)System.getProperty(PREEMPTIVE_AUTHENTICATION), (Object)"true")) {
                HttpHost targetHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
                Companion.getLogger().warn((Function0)new Function0<String>(targetHost){
                    final /* synthetic */ HttpHost $targetHost;

                    @NotNull
                    public final String invoke() {
                        return "Using preemptive basic authentication with the pact broker at " + this.$targetHost;
                    }
                    {
                        this.$targetHost = httpHost;
                        super(0);
                    }
                });
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(targetHost, (AuthScheme)basicAuth);
                HttpClientContext httpClientContext = this.httpContext = HttpClientContext.create();
                if (httpClientContext == null) {
                    Intrinsics.throwNpe();
                }
                httpClientContext.setCredentialsProvider((CredentialsProvider)result.getSecond());
                HttpClientContext httpClientContext2 = this.httpContext;
                if (httpClientContext2 == null) {
                    Intrinsics.throwNpe();
                }
                httpClientContext2.setAuthCache((AuthCache)authCache);
            }
        }
        CloseableHttpClient closeableHttpClient = this.httpClient;
        if (closeableHttpClient == null) {
            Intrinsics.throwNpe();
        }
        return closeableHttpClient;
    }

    @Override
    @NotNull
    public IHalClient navigate() {
        block1: {
            Result<JsonValue.Object, Exception> result;
            block0: {
                result = this.fetch(ROOT);
                if (!(result instanceof Ok)) break block0;
                this.pathInfo = (JsonValue.Object)((Ok)result).getValue();
                break block1;
            }
            if (!(result instanceof Err)) break block1;
            Companion.getLogger().warn((Throwable)((Err)result).getError(), (Function0)navigate.1.INSTANCE);
        }
        return this;
    }

    @Override
    @NotNull
    public IHalClient navigate(@NotNull Map<String, ? extends Object> options, @NotNull String link) {
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        JsonValue.Object object = this.pathInfo;
        if (object == null) {
            object = (JsonValue.Object)KotlinLanguageSupportKt.unwrap(this.fetch(ROOT));
        }
        this.pathInfo = object;
        this.pathInfo = this.fetchLink(link, options);
        return this;
    }

    @Override
    @NotNull
    public IHalClient navigate(@NotNull String link) {
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        HalClient halClient = this;
        boolean bl = false;
        Map map2 = MapsKt.emptyMap();
        return halClient.navigate(map2, link);
    }

    @Override
    @NotNull
    public Result<JsonValue.Object, Exception> fetch(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return this.fetch(path, true);
    }

    @Override
    @NotNull
    public Result<JsonValue.Object, Exception> fetch(@NotNull String path, boolean encodePath) {
        Result result;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.lastUrl = path;
        Companion.getLogger().debug((Function0)new Function0<String>(path){
            final /* synthetic */ String $path;

            @NotNull
            public final String invoke() {
                return "Fetching: " + this.$path;
            }
            {
                this.$path = string;
                super(0);
            }
        });
        Result result2 = this.getJson(path, encodePath);
        if (result2 instanceof Ok) {
            JsonValue jsonValue = (JsonValue)((Ok)result2).getValue();
            result = jsonValue instanceof JsonValue.Object ? (Result)new Ok(((Ok)result2).getValue()) : (Result)new Err((Object)new RuntimeException("Expected a JSON document, but found a " + (JsonValue)((Ok)result2).getValue()));
        } else if (result2 instanceof Err) {
            result = result2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IHalClient withDocContext(@NotNull Map<String, ? extends Object> docAttributes) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(docAttributes, (String)"docAttributes");
        JsonValue.Object links = new JsonValue.Object(new Pair[0]);
        Iterable iterable = docAttributes.entrySet();
        String string = LINKS;
        JsonValue.Object object = links;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JsonValue jsonValue;
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Object v = it.getValue();
            if (v instanceof Map) {
                Collection<Pair> collection2;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Object v2 = it.getValue();
                if (v2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                }
                Iterable iterable2 = ((Map)v2).entrySet();
                Object k2 = k;
                boolean $i$f$map2 = false;
                void var16_18 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void entry2;
                    Map.Entry entry3 = (Map.Entry)item$iv$iv2;
                    collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    Pair pair = Intrinsics.areEqual(entry2.getKey(), (Object)"href") ? TuplesKt.to((Object)String.valueOf(entry2.getKey()), (Object)URLDecoder.decode(String.valueOf(entry2.getValue()), "UTF-8")) : TuplesKt.to((Object)String.valueOf(entry2.getKey()), entry2.getValue());
                    collection2.add(pair);
                }
                collection2 = (List)destination$iv$iv2;
                k = k2;
                jsonValue = (JsonValue)JsonKt.jsonObject((List)collection2);
            } else {
                jsonValue = (JsonValue)JsonValue.Null.INSTANCE;
            }
            Pair pair = TuplesKt.to(k, (Object)jsonValue);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        object.set(string, (Object)JsonKt.jsonObject((List)collection));
        this.pathInfo = links;
        return this;
    }

    @Override
    @NotNull
    public IHalClient withDocContext(@NotNull JsonValue.Object docAttributes) {
        Intrinsics.checkParameterIsNotNull((Object)docAttributes, (String)"docAttributes");
        this.pathInfo = docAttributes;
        return this;
    }

    @Override
    @NotNull
    public Result<JsonValue, Exception> getJson(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return this.getJson(path, true);
    }

    @Override
    @NotNull
    public Result<JsonValue, Exception> getJson(@NotNull String path, boolean encodePath) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.setupHttpClient();
        return KotlinLanguageSupportKt.handleWith((Function0)((Function0)new Function0<Result<? extends JsonValue, ? extends Exception>>(this, path, encodePath){
            final /* synthetic */ HalClient this$0;
            final /* synthetic */ String $path;
            final /* synthetic */ boolean $encodePath;

            @NotNull
            public final Result<JsonValue, Exception> invoke() {
                CloseableHttpResponse response;
                HttpGet httpGet = (HttpGet)this.this$0.initialiseRequest((HttpMessage)new HttpGet(HttpClientUtils.INSTANCE.buildUrl(this.this$0.getBaseUrl(), this.$path, this.$encodePath)));
                httpGet.addHeader("Content-Type", "application/json");
                httpGet.addHeader("Accept", "application/hal+json, application/json");
                CloseableHttpClient closeableHttpClient = this.this$0.getHttpClient();
                if (closeableHttpClient == null) {
                    Intrinsics.throwNpe();
                }
                CloseableHttpResponse closeableHttpResponse = response = closeableHttpClient.execute((HttpUriRequest)httpGet, (HttpContext)this.this$0.getHttpContext());
                Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"response");
                return HalClient.access$handleHalResponse(this.this$0, closeableHttpResponse, this.$path);
            }
            {
                this.this$0 = halClient;
                this.$path = string;
                this.$encodePath = bl;
                super(0);
            }
        }));
    }

    private final Result<JsonValue, Exception> handleHalResponse(CloseableHttpResponse response, String path) {
        Result result;
        StatusLine statusLine = response.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"response.statusLine");
        if (statusLine.getStatusCode() < 300) {
            ContentType contentType;
            ContentType contentType2 = contentType = ContentType.getOrDefault((HttpEntity)response.getEntity());
            Intrinsics.checkExpressionValueIsNotNull((Object)contentType2, (String)"contentType");
            if (HttpClientUtils.INSTANCE.isJsonResponse(contentType2)) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"EntityUtils.toString(response.entity)");
                result = (Result)new Ok((Object)JsonParser.INSTANCE.parseString(string));
            } else {
                result = (Result)new Err((Object)new InvalidHalResponse("Expected a HAL+JSON response from the pact broker, but got '" + contentType + '\''));
            }
        } else {
            Err err;
            StatusLine statusLine2 = response.getStatusLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusLine2, (String)"response.statusLine");
            switch (statusLine2.getStatusCode()) {
                case 404: {
                    err = new Err((Object)new NotFoundHalResponse("No HAL document found at path '" + path + '\''));
                    break;
                }
                default: {
                    err = new Err((Object)new RequestFailedException("Request to path '" + path + "' failed with response '" + response.getStatusLine() + '\''));
                }
            }
            result = (Result)err;
        }
        return result;
    }

    private final JsonValue.Object fetchLink(String link, Map<String, ? extends Object> options) {
        Pair<String, Boolean> href = this.hrefForLink(link, options);
        return (JsonValue.Object)KotlinLanguageSupportKt.unwrap(this.fetch((String)href.getFirst(), (Boolean)href.getSecond()));
    }

    private final Pair<String, Boolean> hrefForLink(String link, Map<String, ? extends Object> options) {
        if (JsonValueKt.get((JsonValue.Object)this.pathInfo, (Object)LINKS).isNull()) {
            throw (Throwable)new InvalidHalResponse("Expected a HAL+JSON response from the pact broker, but got " + "a response with no '_links'. URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
        }
        JsonValue links = JsonValueKt.get((JsonValue.Object)this.pathInfo, (Object)LINKS);
        if (links instanceof JsonValue.Object) {
            if (!links.has(link)) {
                throw (Throwable)new InvalidHalResponse("Link '" + link + "' was not found in the response, only the following links where " + "found: " + ((JsonValue.Object)links).getEntries().keySet() + ". URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
            }
            JsonValue linkData = ((JsonValue.Object)links).get(link);
            if (linkData instanceof JsonValue.Array) {
                if (options.containsKey("name")) {
                    Pair pair;
                    JsonValue linkByName2 = ((JsonValue.Array)linkData).find((Function1)new Function1<JsonValue, Boolean>(options){
                        final /* synthetic */ Map $options;

                        public final boolean invoke(@NotNull JsonValue it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return it instanceof JsonValue.Object && Intrinsics.areEqual((Object)((JsonValue.Object)it).get("name"), this.$options.get("name"));
                        }
                        {
                            this.$options = map2;
                            super(1);
                        }
                    });
                    if (linkByName2 instanceof JsonValue.Object && ((JsonValue.Object)linkByName2).get("templated").isBoolean()) {
                        pair = TuplesKt.to((Object)this.parseLinkUrl(((JsonValue.Object)linkByName2).get("href").toString(), options), (Object)false);
                    } else if (linkByName2 instanceof JsonValue.Object) {
                        pair = TuplesKt.to((Object)((JsonValue.Object)linkByName2).get("href").asString(), (Object)true);
                    } else {
                        throw (Throwable)new InvalidNavigationRequest("Link '" + link + "' does not have an entry with name '" + options.get("name") + "'. " + "URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
                    }
                    return pair;
                }
                throw (Throwable)new InvalidNavigationRequest("Link '" + link + "' has multiple entries. You need to filter by the link name. " + "URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
            }
            if (linkData instanceof JsonValue.Object) {
                return linkData.has("templated") && ((JsonValue.Object)linkData).get("templated").isBoolean() ? TuplesKt.to((Object)this.parseLinkUrl(((JsonValue.Object)linkData).get("href").asString(), options), (Object)false) : TuplesKt.to((Object)((JsonValue.Object)linkData).get("href").asString(), (Object)true);
            }
            throw (Throwable)new InvalidHalResponse("Expected link in map form in the response, but " + "found: " + linkData + ". URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
        }
        throw (Throwable)new InvalidHalResponse("Expected a map of links in the response, but " + "found: " + links + ". URL: '" + this.baseUrl + "', LINK: '" + link + '\'');
    }

    @NotNull
    public final String parseLinkUrl(@NotNull String href, @NotNull Map<String, ? extends Object> options) {
        Intrinsics.checkParameterIsNotNull((Object)href, (String)"href");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        String result = "";
        MatchResult match = Regex.find$default((Regex)URL_TEMPLATE_REGEX, (CharSequence)href, (int)0, (int)2, null);
        int index = 0;
        while (match != null) {
            MatchResult.Destructured destructured;
            int start = match.getRange().getFirst() - 1;
            if (start >= index) {
                int n = index;
                result = result + StringsKt.substring((String)href, (IntRange)new IntRange(n, start));
            }
            index = match.getRange().getLast() + 1;
            MatchResult.Destructured destructured2 = destructured = match.getDestructured();
            boolean bl = false;
            String key = (String)destructured2.getMatch().getGroupValues().get(1);
            result = result + this.encodePathParameter(options, key, match.getValue());
            match = URL_TEMPLATE_REGEX.find((CharSequence)href, index);
        }
        if (index < href.length()) {
            String string = href;
            StringBuilder stringBuilder = new StringBuilder().append(result);
            boolean bl = false;
            String string2 = string.substring(index);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            String string3 = string2;
            result = stringBuilder.append(string3).toString();
        }
        return result;
    }

    private final String encodePathParameter(Map<String, ? extends Object> options, String key, String value) {
        Escaper escaper = UrlEscapers.urlPathSegmentEscaper();
        Object object = options.get(key);
        if (object == null || (object = object.toString()) == null) {
            object = value;
        }
        return escaper.escape((String)object);
    }

    public final void initPathInfo() {
        JsonValue.Object object = this.pathInfo;
        if (object == null) {
            object = (JsonValue.Object)KotlinLanguageSupportKt.unwrap(this.fetch(ROOT));
        }
        this.pathInfo = object;
    }

    @Nullable
    public final Object handleFailure(@NotNull HttpResponse resp, @Nullable String body, @NotNull BiFunction<String, String, Object> closure) {
        Intrinsics.checkParameterIsNotNull((Object)resp, (String)"resp");
        Intrinsics.checkParameterIsNotNull(closure, (String)"closure");
        HttpEntity httpEntity = resp.getEntity();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpEntity, (String)"resp.entity");
        if (httpEntity.getContentType() != null) {
            ContentType contentType;
            ContentType contentType2 = contentType = ContentType.getOrDefault((HttpEntity)resp.getEntity());
            Intrinsics.checkExpressionValueIsNotNull((Object)contentType2, (String)"contentType");
            if (HttpClientUtils.INSTANCE.isJsonResponse(contentType2)) {
                String error = "";
                if (KotlinLanguageSupportKt.isNotEmpty((String)body)) {
                    JsonValue jsonBody;
                    String string = body;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((jsonBody = JsonParser.INSTANCE.parseString(string)).has("errors")) {
                        JsonValue errors = jsonBody.get((Object)"errors");
                        if (errors instanceof JsonValue.Array) {
                            error = " - " + CollectionsKt.joinToString$default((Iterable)((JsonValue.Array)errors).getValues(), (CharSequence)", ", null, null, (int)0, null, (Function1)handleFailure.1.INSTANCE, (int)30, null);
                        } else if (errors instanceof JsonValue.Object) {
                            error = " - " + CollectionsKt.joinToString$default((Iterable)((JsonValue.Object)errors).getEntries().entrySet(), (CharSequence)", ", null, null, (int)0, null, (Function1)handleFailure.2.INSTANCE, (int)30, null);
                        }
                    }
                }
                StringBuilder stringBuilder = new StringBuilder();
                StatusLine statusLine = resp.getStatusLine();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"resp.statusLine");
                StringBuilder stringBuilder2 = stringBuilder.append(statusLine.getStatusCode()).append(' ');
                StatusLine statusLine2 = resp.getStatusLine();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusLine2, (String)"resp.statusLine");
                return closure.apply("FAILED", stringBuilder2.append(statusLine2.getReasonPhrase()).append(error).toString());
            }
            StringBuilder stringBuilder = new StringBuilder();
            StatusLine statusLine = resp.getStatusLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"resp.statusLine");
            StringBuilder stringBuilder3 = stringBuilder.append(statusLine.getStatusCode()).append(' ');
            StatusLine statusLine3 = resp.getStatusLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusLine3, (String)"resp.statusLine");
            return closure.apply("FAILED", stringBuilder3.append(statusLine3.getReasonPhrase()).append(" - ").append(body).toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        StatusLine statusLine = resp.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"resp.statusLine");
        StringBuilder stringBuilder4 = stringBuilder.append(statusLine.getStatusCode()).append(' ');
        StatusLine statusLine4 = resp.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine4, (String)"resp.statusLine");
        return closure.apply("FAILED", stringBuilder4.append(statusLine4.getReasonPhrase()).append(" - ").append(body).toString());
    }

    @Override
    @Nullable
    public String linkUrl(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (this.pathInfo != null) {
            JsonValue.Object object = this.pathInfo;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            if (object.has(LINKS)) {
                JsonValue linkData;
                JsonValue links;
                JsonValue.Object object2 = this.pathInfo;
                if (object2 == null) {
                    Intrinsics.throwNpe();
                }
                if ((links = object2.get(LINKS)) instanceof JsonValue.Object && links.has(name) && (linkData = ((JsonValue.Object)links).get(name)) instanceof JsonValue.Object && linkData.has("href")) {
                    return String.valueOf(Json.INSTANCE.fromJson(((JsonValue.Object)linkData).get("href")));
                }
            }
        }
        return null;
    }

    @Override
    public void forAll(@NotNull String linkName, @NotNull Consumer<Map<String, Object>> closure) {
        JsonValue links;
        Intrinsics.checkParameterIsNotNull((Object)linkName, (String)"linkName");
        Intrinsics.checkParameterIsNotNull(closure, (String)"closure");
        this.initPathInfo();
        JsonValue.Object object = this.pathInfo;
        if (object == null) {
            Intrinsics.throwNpe();
        }
        if ((links = object.get(LINKS)) instanceof JsonValue.Object && links.has(linkName)) {
            JsonValue matchingLink = ((JsonValue.Object)links).get(linkName);
            if (matchingLink instanceof JsonValue.Array) {
                Iterable $this$forEach$iv = ((JsonValue.Array)matchingLink).getValues();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonValue it = (JsonValue)element$iv;
                    boolean bl = false;
                    closure.accept(Companion.asMap(it.asObject()));
                }
            } else {
                closure.accept(Companion.asMap(matchingLink.asObject()));
            }
        }
    }

    @Override
    @NotNull
    public Result<Boolean, Exception> putJson(@NotNull String link, @NotNull Map<String, ? extends Object> options, @NotNull String json) {
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Pair<String, Boolean> href = this.hrefForLink(link, options);
        HttpPut httpPut = (HttpPut)this.initialiseRequest((HttpMessage)new HttpPut(HttpClientUtils.INSTANCE.buildUrl(this.baseUrl, (String)href.getFirst(), (Boolean)href.getSecond())));
        httpPut.addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        httpPut.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        return KotlinLanguageSupportKt.handleWith((Function0)((Function0)new Function0<Boolean>(this, httpPut){
            final /* synthetic */ HalClient this$0;
            final /* synthetic */ HttpPut $httpPut;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final boolean invoke() {
                boolean bl;
                CloseableHttpClient closeableHttpClient = this.this$0.getHttpClient();
                if (closeableHttpClient == null) {
                    Intrinsics.throwNpe();
                }
                Closeable closeable = (Closeable)closeableHttpClient.execute((HttpUriRequest)this.$httpPut, (HttpContext)this.this$0.getHttpContext());
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    boolean bl3;
                    CloseableHttpResponse it = (CloseableHttpResponse)closeable;
                    boolean bl4 = false;
                    CloseableHttpResponse closeableHttpResponse = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                    StatusLine statusLine = closeableHttpResponse.getStatusLine();
                    Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"it.statusLine");
                    if (statusLine.getStatusCode() < 300) {
                        bl3 = true;
                    } else {
                        HalClient.Companion.getLogger().error((Function0)new Function0<String>(it){
                            final /* synthetic */ CloseableHttpResponse $it;

                            @NotNull
                            public final String invoke() {
                                StringBuilder stringBuilder = new StringBuilder().append("PUT JSON request failed with status ");
                                CloseableHttpResponse closeableHttpResponse = this.$it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                                return stringBuilder.append(closeableHttpResponse.getStatusLine()).toString();
                            }
                            {
                                this.$it = closeableHttpResponse;
                                super(0);
                            }
                        });
                        bl3 = false;
                    }
                    bl = bl3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return bl;
            }
            {
                this.this$0 = halClient;
                this.$httpPut = httpPut;
                super(0);
            }
        }));
    }

    @Override
    @NotNull
    public Result<JsonValue.Object, Exception> postJson(@NotNull String link, @NotNull Map<String, ? extends Object> options, @NotNull String json) {
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Pair<String, Boolean> href = this.hrefForLink(link, options);
        HttpPost http = (HttpPost)this.initialiseRequest((HttpMessage)new HttpPost(HttpClientUtils.INSTANCE.buildUrl(this.baseUrl, (String)href.getFirst(), (Boolean)href.getSecond())));
        http.addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        http.addHeader("Accept", "application/hal+json, application/json");
        http.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        return KotlinLanguageSupportKt.handleWith((Function0)((Function0)new Function0<Result<? extends JsonValue, ? extends Exception>>(this, http, href){
            final /* synthetic */ HalClient this$0;
            final /* synthetic */ HttpPost $http;
            final /* synthetic */ Pair $href;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final Result<JsonValue, Exception> invoke() {
                CloseableHttpClient closeableHttpClient = this.this$0.getHttpClient();
                if (closeableHttpClient == null) {
                    Intrinsics.throwNpe();
                }
                Closeable closeable = (Closeable)closeableHttpClient.execute((HttpUriRequest)this.$http, (HttpContext)this.this$0.getHttpContext());
                boolean bl = false;
                Throwable throwable = null;
                try {
                    CloseableHttpResponse it = (CloseableHttpResponse)closeable;
                    boolean bl2 = false;
                    CloseableHttpResponse closeableHttpResponse = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"it");
                    Result result = HalClient.access$handleHalResponse(this.this$0, closeableHttpResponse, (String)this.$href.getFirst());
                    return result;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            {
                this.this$0 = halClient;
                this.$http = httpPost;
                this.$href = pair;
                super(0);
            }
        }));
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public final Map<String, Object> getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull Map<String, ? extends Object> map2) {
        Intrinsics.checkParameterIsNotNull(map2, (String)"<set-?>");
        this.options = map2;
    }

    @JvmOverloads
    public HalClient(@NotNull String baseUrl, @NotNull Map<String, ? extends Object> options) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        this.baseUrl = baseUrl;
        this.options = options;
        HalClient halClient = this;
        boolean bl = false;
        halClient.defaultHeaders = map2 = (Map)new LinkedHashMap();
        this.maxPublishRetries = 5;
        this.publishRetryInterval = 3000;
        if (this.options.containsKey("halClient")) {
            Object object = this.options.get("halClient");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            }
            Map halClient2 = (Map)object;
            Integer n = halClient2.getOrDefault("maxPublishRetries", this.maxPublishRetries);
            if (n == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
            }
            this.maxPublishRetries = n;
            Integer n2 = halClient2.getOrDefault("publishRetryInterval", this.publishRetryInterval);
            if (n2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
            }
            this.publishRetryInterval = n2;
        }
    }

    public /* synthetic */ HalClient(String string, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            boolean bl = false;
            map2 = MapsKt.emptyMap();
        }
        this(string, map2);
    }

    @JvmOverloads
    public HalClient(@NotNull String baseUrl) {
        this(baseUrl, null, 2, null);
    }

    static {
        Companion = new Companion(null);
        URL_TEMPLATE_REGEX = new Regex("\\{(\\w+)\\}");
    }

    public static final /* synthetic */ Result access$handleHalResponse(HalClient $this, CloseableHttpResponse response, String path) {
        return $this.handleHalResponse(response, path);
    }

    @JvmStatic
    @NotNull
    public static final Map<String, Object> asMap(@NotNull JsonValue.Object jsonObject) {
        return Companion.asMap(jsonObject);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lau/com/dius/pact/core/pactbroker/HalClient$Companion;", "Lmu/KLogging;", "()V", "LINKS", "", "PREEMPTIVE_AUTHENTICATION", "ROOT", "URL_TEMPLATE_REGEX", "Lkotlin/text/Regex;", "getURL_TEMPLATE_REGEX", "()Lkotlin/text/Regex;", "asMap", "", "", "jsonObject", "Lau/com/dius/pact/core/support/json/JsonValue$Object;", "pactbroker"})
    public static final class Companion
    extends KLogging {
        @NotNull
        public final Regex getURL_TEMPLATE_REGEX() {
            return URL_TEMPLATE_REGEX;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Map<String, Object> asMap(@NotNull JsonValue.Object jsonObject) {
            void $this$associateTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"jsonObject");
            Iterable $this$associate$iv = jsonObject.getEntries().entrySet();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to(entry.getKey(), (Object)Json.INSTANCE.fromJson((JsonValue)entry.getValue()));
                boolean bl2 = false;
                map2.put(pair.getFirst(), pair.getSecond());
            }
            return destination$iv$iv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

