/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import java.io.File;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springframework.lang.Nullable;

public class AbstractSwaggerResourceResolver {
    private final SwaggerUiConfigProperties swaggerUiConfigProperties;

    public AbstractSwaggerResourceResolver(SwaggerUiConfigProperties swaggerUiConfigProperties) {
        this.swaggerUiConfigProperties = swaggerUiConfigProperties;
    }

    @Nullable
    protected String findWebJarResourcePath(String path) {
        String version;
        String webjar = this.webjar(path);
        if (webjar.length() > 0 && (version = this.swaggerUiConfigProperties.getVersion()) != null) {
            String partialPath = this.path(webjar, path);
            return webjar + File.separator + version + File.separator + partialPath;
        }
        return null;
    }

    private String webjar(String path) {
        int startOffset = path.startsWith("/") ? 1 : 0;
        int endOffset = path.indexOf(47, 1);
        return endOffset != -1 ? path.substring(startOffset, endOffset) : path;
    }

    private String path(String webjar, String path) {
        if (path.startsWith(webjar)) {
            path = path.substring(webjar.length() + 1);
        }
        return path;
    }
}

