/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.config;

import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.services.UsersService;
import org.qubership.atp.auth.springbootstarter.services.client.UsersFeignClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KafkaTemplate;

@Configuration
@EnableFeignClients(value={"org.qubership.atp.auth.springbootstarter.services.client"})
public class ServiceConfiguration {
    private final UsersFeignClient usersFeignClient;

    @Bean
    @ConditionalOnProperty(name={"kafka.enable"}, havingValue="false", matchIfMissing=true)
    public UsersService usersService() {
        return new UsersService(this.usersFeignClient, null);
    }

    @Bean
    @ConditionalOnProperty(name={"kafka.enable"}, havingValue="true")
    public UsersService usersServiceWithKafka(KafkaTemplate<UUID, String> kafkaServiceEntitiesTemplate) {
        return new UsersService(this.usersFeignClient, kafkaServiceEntitiesTemplate);
    }

    public ServiceConfiguration(UsersFeignClient usersFeignClient) {
        this.usersFeignClient = usersFeignClient;
    }
}

