/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import java.net.URL;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpRequestValidationException;
import org.qubership.atp.auth.springbootstarter.feign.exception.FeignClientException;
import org.qubership.atp.auth.springbootstarter.handlers.ErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
@Order(value=0x7FFFFFFF)
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    @Value(value="${atp.handler.exception.include-stack-trace:false}")
    private boolean includeStackTrace;
    @Autowired
    private ObjectMapper feignClientObjectMapper;

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ErrorResponse> commonHandler(Exception exception, HttpServletRequest request) throws Exception {
        ResponseStatus responseStatus;
        boolean isAtpException;
        if (exception instanceof AccessDeniedException) {
            throw exception;
        }
        if (exception instanceof FeignClientException) {
            return this.getFeignClientExceptionResponse(exception);
        }
        if (exception instanceof MethodArgumentNotValidException) {
            exception = new AtpRequestValidationException((MethodArgumentNotValidException)exception);
        }
        if (!(isAtpException = exception instanceof AtpException)) {
            log.error("Found internal server error", (Throwable)exception);
            exception = new AtpException();
        }
        HttpStatus status = (responseStatus = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(exception.getClass(), ResponseStatus.class)) == null ? HttpStatus.INTERNAL_SERVER_ERROR : responseStatus.code();
        String reason = responseStatus == null ? "" : responseStatus.reason();
        ErrorResponse error = ErrorResponse.builder().status(status.value()).path(request.getServletPath()).timestamp(new Date()).message(exception.getMessage()).reason(reason).build();
        if (this.includeStackTrace) {
            error.setTrace(Throwables.getStackTraceAsString((Throwable)exception));
        }
        return ResponseEntity.status((HttpStatus)status).body((Object)error);
    }

    private ResponseEntity<ErrorResponse> getFeignClientExceptionResponse(Exception exception) throws Exception {
        FeignClientException feignException = (FeignClientException)((Object)exception);
        String errorMessage = feignException.getErrorMessage();
        JsonNode errorNode = this.feignClientObjectMapper.readTree(errorMessage);
        Integer status = feignException.getStatus();
        String url = feignException.getRequest().url();
        String path = new URL(url).getPath();
        String message = errorNode.get("message").asText();
        String reason = errorNode.get("reason").asText();
        ErrorResponse error = ErrorResponse.builder().status(status).path(path).timestamp(new Date()).message(message).reason(reason).build();
        return ResponseEntity.status((HttpStatus)HttpStatus.valueOf((int)status)).body((Object)error);
    }
}

