/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.provider.impl;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.keycloak.KeycloakPrincipal;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.springframework.security.core.context.SecurityContextHolder;

public class UserProvider
implements Provider<UserInfo> {
    private final UUID uuid = UUID.fromString("16df9e34-cf21-4360-b89c-785a4ed8f57d");

    @Override
    public UserInfo get() {
        Object principalObject = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        UserInfo user = new UserInfo();
        if (principalObject instanceof KeycloakPrincipal) {
            KeycloakPrincipal principal = (KeycloakPrincipal)principalObject;
            String id = principal.toString();
            String name = principal.getKeycloakSecurityContext().getToken().getName();
            if (Objects.isNull(name)) {
                name = principal.getKeycloakSecurityContext().getToken().getPreferredUsername();
            }
            String firstName = principal.getKeycloakSecurityContext().getToken().getFamilyName();
            String lastName = principal.getKeycloakSecurityContext().getToken().getGivenName();
            String email = principal.getKeycloakSecurityContext().getToken().getEmail();
            Set roles = principal.getKeycloakSecurityContext().getToken().getRealmAccess().getRoles();
            user.setId(UUID.fromString(id));
            user.setUsername(name);
            user.setFirstName(lastName);
            user.setLastName(firstName);
            user.setEmail(email);
            user.setRoles(new ArrayList<String>(roles));
        } else {
            user.setId(this.uuid);
            user.setUsername((String)principalObject);
        }
        return user;
    }
}

