/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.security.filters;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AuthenticatedActionsHandler;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.springsecurity.filter.KeycloakAuthenticatedActionsFilter;
import org.qubership.atp.auth.springbootstarter.security.facades.AnonymousSupportSimpleHttpFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class AnonymousSupportKeycloakAuthenticatedActionsFilter
extends KeycloakAuthenticatedActionsFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnonymousSupportKeycloakAuthenticatedActionsFilter.class);
    private ApplicationContext applicationContext;
    private AdapterDeploymentContext deploymentContext;

    protected void initFilterBean() {
        super.initFilterBean();
        this.deploymentContext = (AdapterDeploymentContext)this.applicationContext.getBean(AdapterDeploymentContext.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        this.applicationContext = applicationContext;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        AnonymousSupportSimpleHttpFacade facade = new AnonymousSupportSimpleHttpFacade((HttpServletRequest)request, (HttpServletResponse)response);
        AuthenticatedActionsHandler handler = new AuthenticatedActionsHandler(this.deploymentContext.resolveDeployment((HttpFacade)facade), (OIDCHttpFacade)facade);
        boolean handled = handler.handledRequest();
        if (handled) {
            LOGGER.debug("Authenticated filter handled request: {}", (Object)((HttpServletRequest)request).getRequestURI());
        } else {
            chain.doFilter(request, response);
        }
    }
}

