/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.security.oauth2.client.config;

import java.security.Principal;
import org.qubership.atp.auth.springbootstarter.services.BearerTokenWebSocketAuthenticator;
import org.qubership.atp.auth.springbootstarter.utils.BearerTokenStompExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class AuthChannelInterceptor
implements ChannelInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthChannelInterceptor.class);
    private final BearerTokenWebSocketAuthenticator webSocketAuthenticatorService;
    private final BearerTokenStompExtractor bearerTokenStompExtractor;

    public Message<?> preSend(Message<?> message, MessageChannel channel) throws MessagingException {
        log.debug("start preSend(message: {}, channel: {})", message, (Object)channel);
        StompHeaderAccessor accessor = (StompHeaderAccessor)MessageHeaderAccessor.getAccessor(message, StompHeaderAccessor.class);
        log.debug("accessor {}", (Object)accessor);
        if (accessor == null) {
            return message;
        }
        log.debug("accessor's command {}", (Object)accessor.getCommand());
        if (StompCommand.CONNECT == accessor.getCommand()) {
            Authentication user;
            String token = this.bearerTokenStompExtractor.extract(accessor);
            try {
                user = this.webSocketAuthenticatorService.authenticate(token);
            }
            catch (AuthenticationException e) {
                log.error("Authentication failed.", (Throwable)e);
                throw new MessagingException("Authentication failed. " + e.getMessage());
            }
            log.debug("user {}", (Object)user);
            accessor.setUser((Principal)user);
        }
        return message;
    }

    public AuthChannelInterceptor(BearerTokenWebSocketAuthenticator webSocketAuthenticatorService, BearerTokenStompExtractor bearerTokenStompExtractor) {
        this.webSocketAuthenticatorService = webSocketAuthenticatorService;
        this.bearerTokenStompExtractor = bearerTokenStompExtractor;
    }
}

