/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.security.permissions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.auth.springbootstarter.entities.Operation;
import org.qubership.atp.auth.springbootstarter.entities.Permissions;
import org.qubership.atp.auth.springbootstarter.entities.Project;

public interface PolicyEnforcement {
    default public boolean checkAccess(String projectId, String action) {
        return this.checkAccess(StringUtils.isBlank((CharSequence)projectId) ? null : UUID.fromString(projectId), Operation.valueOf(action.toUpperCase()));
    }

    default public boolean checkAccess(UUID projectId, String action) {
        return this.checkAccess(projectId, Operation.valueOf(action.toUpperCase()));
    }

    public boolean checkAccess(Set<UUID> var1, String var2);

    public boolean checkAccess(UUID var1, Operation var2);

    public boolean checkAccess(String var1, UUID var2, Operation var3);

    public boolean checkAccess(String var1, Set<UUID> var2, Operation var3);

    public boolean checkAccess(String var1, Set<UUID> var2, String var3);

    default public boolean checkAccess(String entityName, UUID projectId, String action) {
        return this.checkAccess(entityName, projectId, Operation.valueOf(action.toUpperCase()));
    }

    default public boolean checkAccess(String entityName, String projectId, String action) {
        return this.checkAccess(entityName, UUID.fromString(projectId), Operation.valueOf(action.toUpperCase()));
    }

    public boolean checkAccess(String var1, UUID var2, UUID var3, Operation var4);

    default public boolean checkAccess(String entityName, UUID projectId, UUID objectId, String operation) {
        return this.checkAccess(entityName, projectId, objectId, Operation.valueOf(operation));
    }

    public boolean checkAccess(String var1, UUID var2, Set<UUID> var3, Operation var4);

    default public boolean checkAccess(String entityName, UUID projectId, Set<UUID> objectIds, String operation) {
        return this.checkAccess(entityName, projectId, objectIds, Operation.valueOf(operation));
    }

    public boolean isAdmin();

    public boolean isSupport();

    public boolean isAuthenticated();

    default public Project getProjectEntityWithGroup(UUID projectId, List<UUID> leads, List<UUID> qaTaEngineers, List<UUID> devOpsEngineers, List<UUID> atpRunners, List<UUID> atpSupports, Permissions permissions) {
        Project project = new Project();
        project.setUuid(projectId);
        project.setLeads(new HashSet<UUID>(leads));
        project.setQaTaEngineers(new HashSet<UUID>(qaTaEngineers));
        project.setDevOpsEngineers(new HashSet<UUID>(devOpsEngineers));
        project.setAtpRunners(new HashSet<UUID>(atpRunners));
        project.setAtpSupports(new HashSet<UUID>(atpSupports));
        project.setPermissions(permissions);
        return project;
    }

    public boolean checkPoliciesForOperation(Project var1, Operation var2);

    public boolean checkPoliciesForOperation(String var1, Project var2, Operation var3);
}

