/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.ssl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ResourceUtils;

public class SslCertificateProvider
implements Provider<List<Certificate>> {
    private static final String CERTIFICATE_PATH = "X.509";
    private List<Certificate> certificateList;
    @Value(value="${atp-auth.ssl.certificate.dir.path}")
    private String dirPath;

    @Override
    public List<Certificate> get() {
        if (Objects.isNull(this.certificateList)) {
            this.certificateList = this.loadCertificateList();
        }
        return this.certificateList;
    }

    private List<Certificate> loadCertificateList() {
        try {
            return Stream.of(ResourceUtils.getFile((String)this.dirPath).listFiles()).map(this::loadCertificate).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException("Can not load ssl certificate.", e);
        }
    }

    private Certificate loadCertificate(File file) {
        if (file.isDirectory()) {
            return null;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance(CERTIFICATE_PATH);
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
            return certificateFactory.generateCertificate(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Can not load ssl certificate.", e);
        }
    }
}

