/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.schema;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import org.polyjdbc.core.exception.SchemaManagerException;
import org.polyjdbc.core.schema.DDLQuery;
import org.polyjdbc.core.schema.SchemaManager;
import org.polyjdbc.core.schema.model.Schema;
import org.polyjdbc.core.schema.model.SchemaEntity;
import org.polyjdbc.core.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaManagerImpl
implements SchemaManager {
    private static final Logger logger = LoggerFactory.getLogger(SchemaManagerImpl.class);
    private final Transaction transaction;

    SchemaManagerImpl(Transaction transaction) {
        this.transaction = transaction;
    }

    @Override
    public void create(Schema schema) {
        ArrayList<SchemaEntity> entitiesToCreate = new ArrayList<SchemaEntity>(schema.getEntities());
        if (schema.getDialect().supportsSequences()) {
            entitiesToCreate.addAll(schema.getSequences());
        }
        for (SchemaEntity entity : entitiesToCreate) {
            String ddlText = entity.ddl();
            logger.info("creating entity with name {} using ddl:\n{}", (Object)entity.getName(), (Object)ddlText);
            this.ddl(DDLQuery.ddl(ddlText));
        }
    }

    @Override
    public void create(SchemaEntity entity) {
        this.ddl(DDLQuery.ddl(entity.ddl()));
    }

    @Override
    public void drop(Schema schema) {
        ArrayList<SchemaEntity> entitiesToDrop = new ArrayList<SchemaEntity>(schema.getEntities());
        Collections.reverse(entitiesToDrop);
        if (schema.getDialect().supportsSequences()) {
            entitiesToDrop.addAll(schema.getSequences());
        }
        for (SchemaEntity entity : entitiesToDrop) {
            String ddlText = entity.dropDDL();
            logger.info("dropping entity with name {} using ddl:\n{}", (Object)entity.getName(), (Object)ddlText);
            this.ddl(DDLQuery.ddl(ddlText));
        }
    }

    @Override
    public void drop(SchemaEntity entity) {
        this.ddl(DDLQuery.ddl(entity.dropDDL()));
    }

    @Override
    public void ddl(DDLQuery ddlQuery) {
        String textQuery = ddlQuery.build();
        try {
            Statement statement = this.transaction.createStatement();
            statement.execute(textQuery);
        }
        catch (SQLException exception) {
            this.transaction.rollback();
            throw new SchemaManagerException("DDL_ERROR", String.format("Failed to run DDL:%n%s", textQuery), exception);
        }
    }

    @Override
    public void close() {
        this.transaction.commit();
        this.transaction.close();
    }
}

