/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.schema.model;

import java.util.Arrays;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.schema.model.SchemaPart;

public abstract class Attribute
implements SchemaPart {
    static final int TO_STRING_LENGTH = 100;
    private Dialect dialect;
    private String name;
    private boolean unique;
    private boolean notNull;
    private Object defaultValue;
    private String[] additionalModifiers;

    Attribute(Dialect dialect, String name) {
        this.dialect = dialect;
        this.name = name;
    }

    protected abstract String getTypeDefinition();

    protected Dialect dialect() {
        return this.dialect;
    }

    public String toString() {
        return this.ddl();
    }

    @Override
    public String ddl() {
        StringBuilder builder = new StringBuilder(100);
        builder.append(this.name).append(" ").append(this.getTypeDefinition()).append(" ");
        builder.append(this.dialect.constraints().attributeModifiers(this.unique, this.notNull, this.defaultValue)).append(" ");
        if (this.additionalModifiers != null) {
            for (String additionalModifier : this.additionalModifiers) {
                if (!this.dialect.supportsAttributeModifier(additionalModifier)) continue;
                builder.append(additionalModifier).append(" ");
            }
        }
        return builder.toString().trim();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isUnique() {
        return this.unique;
    }

    void unique() {
        this.unique = true;
    }

    void clearUniqueConstraint() {
        this.unique = false;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    void notNull() {
        this.notNull = true;
    }

    public String[] getAdditionalModifiers() {
        return Arrays.copyOf(this.additionalModifiers, this.additionalModifiers.length);
    }

    void withAdditionalModifiers(String ... additionalModifiers) {
        this.additionalModifiers = Arrays.copyOf(additionalModifiers, additionalModifiers.length);
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    void withDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }
}

