/*
 * Decompiled with CFR 0.152.
 */
package org.polyjdbc.core.schema.model;

import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.schema.model.Attribute;
import org.polyjdbc.core.schema.model.AttributeBuilder;
import org.polyjdbc.core.schema.model.RelationBuilder;

public class NumberAttribute
extends Attribute {
    private int integerPrecision;
    private int decimalPrecision;

    public NumberAttribute(Dialect dialect, String name) {
        super(dialect, name);
    }

    @Override
    protected String getTypeDefinition() {
        return this.dialect().types().number(this.integerPrecision, this.decimalPrecision);
    }

    void withIntegerPrecision(int integerPrecision) {
        this.integerPrecision = integerPrecision;
    }

    void withDecimalPrecision(int decimalPrecision) {
        this.decimalPrecision = decimalPrecision;
    }

    public static class NumberAttributeBuilder
    extends AttributeBuilder<NumberAttributeBuilder, NumberAttribute> {
        private NumberAttributeBuilder(Dialect dialect, String name, RelationBuilder parent) {
            super(new NumberAttribute(dialect, name), parent);
        }

        public static NumberAttributeBuilder number(Dialect dialect, String name, RelationBuilder parent) {
            return new NumberAttributeBuilder(dialect, name, parent);
        }

        @Override
        protected NumberAttributeBuilder self() {
            return this;
        }

        public NumberAttributeBuilder withIntegerPrecision(int integerPrecision) {
            ((NumberAttribute)this.attribute()).withIntegerPrecision(integerPrecision);
            return this.self();
        }

        public NumberAttributeBuilder withDecimalPrecision(int decimalPrecision) {
            ((NumberAttribute)this.attribute()).withDecimalPrecision(decimalPrecision);
            return this.self();
        }
    }
}

