/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.BaseFilter;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenReaderFilter;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.utils.io.FileUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.plexus.build.incremental.BuildContext;

@Component(role=MavenFileFilter.class, hint="default")
public class DefaultMavenFileFilter
extends BaseFilter
implements MavenFileFilter {
    @Requirement
    private MavenReaderFilter readerFilter;
    @Requirement
    private BuildContext buildContext;

    @Override
    public void copyFile(File from, File to, boolean filtering, MavenProject mavenProject, List<String> filters, boolean escapedBackslashesInFilePath, String encoding, MavenSession mavenSession) throws MavenFilteringException {
        MavenResourcesExecution mre = new MavenResourcesExecution();
        mre.setMavenProject(mavenProject);
        mre.setFileFilters(filters);
        mre.setEscapeWindowsPaths(escapedBackslashesInFilePath);
        mre.setMavenSession(mavenSession);
        mre.setInjectProjectBuildFilters(true);
        List filterWrappers = this.getDefaultFilterWrappers(mre);
        this.copyFile(from, to, filtering, filterWrappers, encoding);
    }

    @Override
    public void copyFile(MavenFileFilterRequest mavenFileFilterRequest) throws MavenFilteringException {
        List filterWrappers = this.getDefaultFilterWrappers(mavenFileFilterRequest);
        this.copyFile(mavenFileFilterRequest.getFrom(), mavenFileFilterRequest.getTo(), mavenFileFilterRequest.isFiltering(), filterWrappers, mavenFileFilterRequest.getEncoding());
    }

    @Override
    public void copyFile(File from, File to, boolean filtering, List<FileUtils.FilterWrapper> filterWrappers, String encoding) throws MavenFilteringException {
        this.copyFile(from, to, filtering, filterWrappers, encoding, false);
    }

    @Override
    public void copyFile(File from, File to, boolean filtering, List<FileUtils.FilterWrapper> filterWrappers, String encoding, boolean overwrite) throws MavenFilteringException {
        try {
            if (filtering) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("filtering " + from.getPath() + " to " + to.getPath());
                }
                FileUtils.FilterWrapper[] array = filterWrappers.toArray(new FileUtils.FilterWrapper[0]);
                FileUtils.copyFile((File)from, (File)to, (String)encoding, (FileUtils.FilterWrapper[])array, (boolean)false);
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("copy " + from.getPath() + " to " + to.getPath());
                }
                FileUtils.copyFile((File)from, (File)to, (String)encoding, (FileUtils.FilterWrapper[])new FileUtils.FilterWrapper[0], (boolean)overwrite);
            }
            this.buildContext.refresh(to);
        }
        catch (IOException e) {
            throw new MavenFilteringException(e.getMessage(), e);
        }
    }
}

