/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model;

import au.com.dius.pact.core.model.BasePact;
import au.com.dius.pact.core.model.BrokerUrlSource;
import au.com.dius.pact.core.model.ClosurePactSource;
import au.com.dius.pact.core.model.Consumer;
import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.FileSource;
import au.com.dius.pact.core.model.InputStreamPactSource;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactReader;
import au.com.dius.pact.core.model.PactReaderKt;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.Provider;
import au.com.dius.pact.core.model.ReaderPactSource;
import au.com.dius.pact.core.model.Request;
import au.com.dius.pact.core.model.RequestResponsePact;
import au.com.dius.pact.core.model.Response;
import au.com.dius.pact.core.model.S3PactSource;
import au.com.dius.pact.core.model.UnknownPactSource;
import au.com.dius.pact.core.model.UrlPactSource;
import au.com.dius.pact.core.model.UrlSource;
import au.com.dius.pact.core.model.messaging.MessagePact;
import au.com.dius.pact.core.pactbroker.PactBrokerResult;
import au.com.dius.pact.core.support.HttpClient;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.JsonKt;
import au.com.dius.pact.core.support.json.JsonException;
import au.com.dius.pact.core.support.json.JsonParser;
import au.com.dius.pact.core.support.json.JsonValue;
import au.com.dius.pact.core.support.json.JsonValueKt;
import com.github.zafarkhaja.semver.Version;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J2\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u00072\u0014\b\u0002\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\"H\u0002J\u0014\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010 \u001a\u00020\u0007H\u0016J(\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010 \u001a\u00020\u00072\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\"H\u0016J\u001c\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u0007H\u0002J\u001c\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u000fH\u0007J\u001c\u0010+\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u000fH\u0007J\u0018\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u0005H\u0002J\u0010\u0010/\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000fH\u0007J\u0010\u00100\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u00061"}, d2={"Lau/com/dius/pact/core/model/DefaultPactReader;", "Lau/com/dius/pact/core/model/PactReader;", "Lmu/KLogging;", "()V", "CLASSPATH_URI_START", "", "s3Client", "", "s3Client$annotations", "getS3Client", "()Ljava/lang/Object;", "setS3Client", "(Ljava/lang/Object;)V", "determineSpecVersion", "pactInfo", "Lau/com/dius/pact/core/support/json/JsonValue$Object;", "extractRequest", "Lau/com/dius/pact/core/model/Request;", "requestJson", "extractResponse", "Lau/com/dius/pact/core/model/Response;", "responseJson", "fileExists", "", "path", "formatBody", "", "json", "Lau/com/dius/pact/core/support/json/JsonValue;", "loadFile", "Lkotlin/Pair;", "Lau/com/dius/pact/core/model/PactSource;", "source", "options", "", "loadPact", "Lau/com/dius/pact/core/model/Pact;", "loadPactFromClasspath", "loadPactFromFile", "loadPactFromS3Bucket", "loadV2Pact", "Lau/com/dius/pact/core/model/RequestResponsePact;", "pactJson", "loadV3Pact", "specVersion", "specification", "defaultVersion", "transformJson", "transformRequestResponseJson", "model"})
public final class DefaultPactReader
extends KLogging
implements PactReader {
    private static final String CLASSPATH_URI_START = "classpath:";
    @NotNull
    public static Object s3Client;
    public static final DefaultPactReader INSTANCE;

    @JvmStatic
    public static /* synthetic */ void s3Client$annotations() {
    }

    @NotNull
    public static final Object getS3Client() {
        Object object = s3Client;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"s3Client");
        }
        return object;
    }

    public static final void setS3Client(@NotNull Object object) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"<set-?>");
        s3Client = object;
    }

    @Override
    @NotNull
    public Pact<?> loadPact(@NotNull Object source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        return this.loadPact(source, MapsKt.emptyMap());
    }

    @Override
    @NotNull
    public Pact<?> loadPact(@NotNull Object source, @NotNull Map<String, ? extends Object> options) {
        Pact pact;
        Version specVersion;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        Pair<JsonValue.Object, PactSource> pactInfo = this.loadFile(source, options);
        String version = DefaultPactReader.determineSpecVersion((JsonValue.Object)pactInfo.getFirst());
        Version version2 = specVersion = Version.valueOf((String)version);
        Intrinsics.checkExpressionValueIsNotNull((Object)version2, (String)"specVersion");
        switch (version2.getMajorVersion()) {
            case 3: {
                pact = DefaultPactReader.loadV3Pact((PactSource)pactInfo.getSecond(), (JsonValue.Object)pactInfo.getFirst());
                break;
            }
            default: {
                pact = DefaultPactReader.loadV2Pact((PactSource)pactInfo.getSecond(), (JsonValue.Object)pactInfo.getFirst());
            }
        }
        return pact;
    }

    @JvmStatic
    @NotNull
    public static final String determineSpecVersion(@NotNull JsonValue.Object pactInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pactInfo, (String)"pactInfo");
        String version = "2.0.0";
        if (pactInfo.has("metadata")) {
            JsonValue.Object metadata = pactInfo.get("metadata").asObject();
            String string = metadata.has("pactSpecificationVersion") ? metadata.get("pactSpecificationVersion").asString() : (metadata.has("pactSpecification") ? INSTANCE.specVersion(metadata.get("pactSpecification"), version) : (version = metadata.has("pact-specification") ? INSTANCE.specVersion(metadata.get("pact-specification"), version) : version));
        }
        if (Intrinsics.areEqual((Object)version, (Object)"3.0")) {
            version = "3.0.0";
        }
        return version;
    }

    private final String specVersion(JsonValue specification, String defaultVersion) {
        if (!(specification instanceof JsonValue.Object && specification.has("version") && ((JsonValue.Object)specification).get("version").isString())) {
            return defaultVersion;
        }
        return ((JsonValue.Object)specification).get("version").asString();
    }

    @JvmStatic
    @NotNull
    public static final Pact<?> loadV3Pact(@NotNull PactSource source, @NotNull JsonValue.Object pactJson) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)pactJson, (String)"pactJson");
        if (pactJson.has("messages")) {
            return MessagePact.Companion.fromJson(pactJson, source);
        }
        JsonValue.Object transformedJson = DefaultPactReader.transformJson(pactJson);
        Provider provider = Provider.Companion.fromJson(transformedJson.get("provider"));
        Consumer consumer = Consumer.Companion.fromJson(transformedJson.get("consumer"));
        List interactions2 = JsonValueKt.map((JsonValue)transformedJson.get("interactions"), (Function1)loadV3Pact.interactions.1.INSTANCE);
        return new RequestResponsePact(provider, consumer, CollectionsKt.toMutableList((Collection)interactions2), BasePact.Companion.metaData(transformedJson.get("metadata"), PactSpecVersion.V3), source);
    }

    @JvmStatic
    @NotNull
    public static final RequestResponsePact loadV2Pact(@NotNull PactSource source, @NotNull JsonValue.Object pactJson) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)pactJson, (String)"pactJson");
        JsonValue.Object transformedJson = DefaultPactReader.transformJson(pactJson);
        Provider provider = Provider.Companion.fromJson(transformedJson.get("provider"));
        Consumer consumer = Consumer.Companion.fromJson(transformedJson.get("consumer"));
        List interactions2 = transformedJson.has("interactions") ? JsonValueKt.map((JsonValue)((JsonValue)transformedJson.get("interactions").asArray()), (Function1)loadV2Pact.interactions.1.INSTANCE) : CollectionsKt.emptyList();
        return new RequestResponsePact(provider, consumer, CollectionsKt.toMutableList((Collection)interactions2), BasePact.Companion.metaData(transformedJson.get("metadata"), PactSpecVersion.V2), source);
    }

    @JvmStatic
    @NotNull
    public static final Response extractResponse(@NotNull JsonValue.Object responseJson) {
        Intrinsics.checkParameterIsNotNull((Object)responseJson, (String)"responseJson");
        INSTANCE.formatBody((JsonValue)responseJson);
        return Response.Companion.fromJson(responseJson);
    }

    @JvmStatic
    @NotNull
    public static final Request extractRequest(@NotNull JsonValue.Object requestJson) {
        Intrinsics.checkParameterIsNotNull((Object)requestJson, (String)"requestJson");
        INSTANCE.formatBody((JsonValue)requestJson);
        return Request.Companion.fromJson(requestJson);
    }

    private final void formatBody(JsonValue json) {
        JsonValue body;
        if (json instanceof JsonValue.Object && json.has("body") && !((body = ((JsonValue.Object)json).get("body")) instanceof JsonValue.Null) && !(body instanceof JsonValue.StringValue)) {
            ((JsonValue.Object)json).set("body", (Object)body.serialise());
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final JsonValue.Object transformJson(@NotNull JsonValue.Object pactJson) {
        Intrinsics.checkParameterIsNotNull((Object)pactJson, (String)"pactJson");
        if (pactJson.has("interactions") && pactJson.get("interactions") instanceof JsonValue.Array) {
            pactJson.set("interactions", (Object)JsonKt.jsonArray((List)JsonValueKt.map((JsonValue)((JsonValue)pactJson.get("interactions").asArray()), (Function1)transformJson.1.INSTANCE)));
        }
        if (pactJson.has("metadata") && pactJson.get("metadata") instanceof JsonValue.Object) {
            Collection<Pair> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = pactJson.get("metadata").asObject().getEntries().entrySet();
            String string = "metadata";
            JsonValue.Object object = pactJson;
            boolean $i$f$map = false;
            void var3_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair;
                void entry;
                Map.Entry entry2 = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string2 = (String)entry.getKey();
                switch (string2.hashCode()) {
                    case -2064928616: {
                        if (string2.equals("pact-specification")) {
                            pair = TuplesKt.to((Object)"pactSpecification", entry.getValue());
                            break;
                        }
                    }
                    default: {
                        void var11_13 = entry;
                        boolean bl2 = false;
                        pair = new Pair(var11_13.getKey(), var11_13.getValue());
                    }
                }
                Pair pair2 = pair;
                collection.add(pair2);
            }
            collection = (List)destination$iv$iv;
            object.set(string, (Object)JsonKt.jsonObject((List)collection));
        }
        return pactJson;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonValue.Object transformRequestResponseJson(JsonValue.Object requestJson) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = requestJson.getEntries().entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair;
            void k;
            void $dstr$k$v;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_11 = $dstr$k$v;
            boolean bl2 = false;
            String string = (String)var11_11.getKey();
            var11_11 = $dstr$k$v;
            bl2 = false;
            JsonValue v = (JsonValue)var11_11.getValue();
            switch (k) {
                case "responseMatchingRules": {
                    pair = TuplesKt.to((Object)"matchingRules", (Object)v);
                    break;
                }
                case "requestMatchingRules": {
                    pair = TuplesKt.to((Object)"matchingRules", (Object)v);
                    break;
                }
                case "method": {
                    String string2;
                    String string3 = Json.INSTANCE.toString(v);
                    String string4 = "method";
                    boolean bl3 = false;
                    String string5 = string3;
                    if (string5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5.toUpperCase(), (String)"(this as java.lang.String).toUpperCase()");
                    pair = TuplesKt.to((Object)string4, (Object)string2);
                    break;
                }
                default: {
                    pair = TuplesKt.to((Object)k, (Object)v);
                }
            }
            Pair pair2 = pair;
            collection.add(pair2);
        }
        return JsonKt.jsonObject((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<JsonValue.Object, PactSource> loadFile(Object source, Map<String, ? extends Object> options) {
        boolean bl;
        Object object;
        Object urlSource2;
        if (source instanceof ClosurePactSource) {
            Object object2 = ((ClosurePactSource)source).getClosure().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"source.closure.get()");
            return this.loadFile(object2, options);
        }
        if (source instanceof FileSource) {
            Object object3 = ((FileSource)source).getFile();
            Charset charset = Charsets.UTF_8;
            int n = 8192;
            boolean bl2 = false;
            Object object4 = object3;
            boolean bl3 = false;
            Object object5 = object4;
            boolean bl4 = false;
            object5 = new FileInputStream((File)object5);
            bl4 = false;
            object4 = new InputStreamReader((InputStream)object5, charset);
            bl3 = false;
            object3 = object4 instanceof BufferedReader ? (BufferedReader)object4 : new BufferedReader((Reader)object4, n);
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)object3;
                boolean bl6 = false;
                it = TuplesKt.to((Object)JsonParser.INSTANCE.parseReader((Reader)it).asObject(), (Object)source);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
            }
            return it;
        }
        if (source instanceof InputStream || source instanceof Reader || source instanceof File) {
            return this.loadPactFromFile(source);
        }
        if (source instanceof BrokerUrlSource) {
            URI uRI = new URI(((BrokerUrlSource)source).getPactBrokerUrl());
            Object object6 = options.get("authentication");
            HttpClient httpClient = HttpClient.INSTANCE;
            boolean bl7 = false;
            Map map = new LinkedHashMap();
            Closeable closeable = (Closeable)HttpClient.newHttpClient$default((HttpClient)httpClient, (Object)object6, (URI)uRI, (Map)map, (int)0, (int)0, (int)24, null).getFirst();
            boolean bl8 = false;
            Throwable throwable = null;
            try {
                Pair<JsonValue.Object, PactSource> it = (Pair<JsonValue.Object, PactSource>)closeable;
                boolean bl9 = false;
                it = PactReaderKt.loadPactFromUrl((UrlPactSource)source, options, (CloseableHttpClient)it);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return it;
        }
        if (source instanceof PactBrokerResult) {
            Pair<JsonValue.Object, PactSource> pair;
            URI uRI = new URI(((PactBrokerResult)source).getPactBrokerUrl());
            Object object7 = options.get("authentication");
            HttpClient httpClient = HttpClient.INSTANCE;
            boolean bl10 = false;
            Map map = new LinkedHashMap();
            Closeable closeable = (Closeable)HttpClient.newHttpClient$default((HttpClient)httpClient, (Object)object7, (URI)uRI, (Map)map, (int)0, (int)0, (int)24, null).getFirst();
            boolean bl11 = false;
            Throwable throwable = null;
            try {
                CloseableHttpClient it = (CloseableHttpClient)closeable;
                boolean bl12 = false;
                pair = PactReaderKt.loadPactFromUrl(BrokerUrlSource.Companion.fromResult((PactBrokerResult)source, options), options, it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return pair;
        }
        if (source instanceof URL || source instanceof UrlPactSource) {
            UrlPactSource urlSource2 = source instanceof URL ? (UrlPactSource)new UrlSource(source.toString(), null, 2, null) : (UrlPactSource)source;
            return PactReaderKt.loadPactFromUrl(urlSource2, options, PactReaderKt.newHttpClient(urlSource2.getUrl(), options));
        }
        if (source instanceof String) {
            urlSource2 = (String)source;
            boolean bl13 = false;
            String string = ((String)urlSource2).toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase()");
            urlSource2 = string;
            object = new Regex("(https?|file)://?.*");
            bl = false;
            if (object.matches((CharSequence)urlSource2)) {
                urlSource2 = new UrlSource((String)source, null, 2, null);
                return PactReaderKt.loadPactFromUrl((UrlPactSource)urlSource2, options, PactReaderKt.newHttpClient(((UrlSource)urlSource2).getUrl(), options));
            }
        }
        if (source instanceof String) {
            urlSource2 = (String)source;
            boolean bl14 = false;
            String string = ((String)urlSource2).toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase()");
            urlSource2 = string;
            object = new Regex("s3://.*");
            bl = false;
            if (object.matches((CharSequence)urlSource2)) {
                return this.loadPactFromS3Bucket((String)source);
            }
        }
        if (source instanceof String && StringsKt.startsWith$default((String)((String)source), (String)CLASSPATH_URI_START, (boolean)false, (int)2, null)) {
            urlSource2 = (String)source;
            int n = CLASSPATH_URI_START.length();
            DefaultPactReader defaultPactReader = this;
            bl = false;
            String string = ((String)urlSource2).substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            String string2 = string;
            return defaultPactReader.loadPactFromClasspath(string2);
        }
        if (source instanceof String && this.fileExists((String)source)) {
            Pair pair;
            File file = new File((String)source);
            object = file;
            Charset charset = Charsets.UTF_8;
            int n = 8192;
            boolean bl12 = false;
            Object object8 = object;
            boolean bl15 = false;
            Object object9 = object8;
            boolean bl16 = false;
            object9 = new FileInputStream((File)object9);
            bl16 = false;
            object8 = new InputStreamReader((InputStream)object9, charset);
            bl15 = false;
            object = object8 instanceof BufferedReader ? (BufferedReader)object8 : new BufferedReader((Reader)object8, n);
            boolean bl17 = false;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl18 = false;
                pair = TuplesKt.to((Object)JsonParser.INSTANCE.parseReader((Reader)it).asObject(), new FileSource(file, null, 2, null));
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            return pair;
        }
        try {
            return TuplesKt.to((Object)JsonParser.INSTANCE.parseString(source.toString()).asObject(), (Object)UnknownPactSource.INSTANCE);
        }
        catch (JsonException e) {
            throw (Throwable)new UnsupportedOperationException("Unable to load pact file from '" + source + "' as it is neither a json document, file, input stream, " + "reader or an URL", e);
        }
    }

    static /* synthetic */ Pair loadFile$default(DefaultPactReader defaultPactReader, Object object, Map map, int n, Object object2) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return defaultPactReader.loadFile(object, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<JsonValue.Object, PactSource> loadPactFromFile(Object source) {
        Pair pair;
        Object object = source;
        if (object instanceof InputStream) {
            pair = TuplesKt.to((Object)JsonParser.INSTANCE.parseReader((Reader)new InputStreamReader((InputStream)source)).asObject(), (Object)InputStreamPactSource.INSTANCE);
        } else if (object instanceof Reader) {
            pair = TuplesKt.to((Object)JsonParser.INSTANCE.parseReader((Reader)source).asObject(), (Object)ReaderPactSource.INSTANCE);
        } else if (object instanceof File) {
            JsonValue.Object object2;
            Object object3 = (File)source;
            Charset charset = Charsets.UTF_8;
            int n = 8192;
            boolean bl = false;
            Object object4 = object3;
            boolean bl2 = false;
            Object object5 = object4;
            boolean bl3 = false;
            object5 = new FileInputStream((File)object5);
            bl3 = false;
            object4 = new InputStreamReader((InputStream)object5, charset);
            bl2 = false;
            object3 = object4 instanceof BufferedReader ? (BufferedReader)object4 : new BufferedReader((Reader)object4, n);
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)object3;
                boolean bl5 = false;
                object2 = JsonParser.INSTANCE.parseReader((Reader)it).asObject();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
            }
            pair = TuplesKt.to((Object)object2, new FileSource((File)source, null, 2, null));
        } else {
            throw (Throwable)new IllegalArgumentException("loadPactFromFile expects either an InputStream, Reader or File. " + "Got a " + source.getClass().getName() + " instead");
        }
        return pair;
    }

    private final Pair<JsonValue.Object, PactSource> loadPactFromS3Bucket(String source) {
        Class<?> amazonS3URIClass = Class.forName("com.amazonaws.services.s3.AmazonS3URI");
        Object s3Uri = amazonS3URIClass.getConstructor(String.class).newInstance(source);
        String bucket = amazonS3URIClass.getMethod("getBucket", new Class[0]).invoke(s3Uri, new Object[0]).toString();
        String key = amazonS3URIClass.getMethod("getKey", new Class[0]).invoke(s3Uri, new Object[0]).toString();
        if (s3Client == null) {
            Class<?> amazonS3ClientBuilderClass = Class.forName("com.amazonaws.services.s3.AmazonS3ClientBuilder");
            Object object = amazonS3ClientBuilderClass.getMethod("defaultClient", new Class[0]).invoke(null, new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"amazonS3ClientBuilderCla\u2026aultClient\").invoke(null)");
            s3Client = object;
        }
        Class<?> s3ClientClass = Class.forName("com.amazonaws.services.s3.AmazonS3");
        Method method = s3ClientClass.getMethod("getObject", String.class, String.class);
        Object object = s3Client;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"s3Client");
        }
        Object s3Pact = method.invoke(object, bucket, key);
        Class<?> s3ObjectClass = Class.forName("com.amazonaws.services.s3.model.S3Object");
        Object object2 = s3ObjectClass.getMethod("getObjectContent", new Class[0]).invoke(s3Pact, new Object[0]);
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.io.InputStream");
        }
        InputStream objectContent = (InputStream)object2;
        return TuplesKt.to((Object)JsonParser.INSTANCE.parseReader((Reader)new InputStreamReader(objectContent)).asObject(), (Object)new S3PactSource(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<JsonValue.Object, PactSource> loadPactFromClasspath(String source) {
        Pair<JsonValue.Object, PactSource> pair;
        Thread thread = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
        InputStream inputStream = thread.getContextClassLoader().getResourceAsStream(source);
        if (inputStream == null) {
            throw (Throwable)new IllegalStateException("not found on classpath: " + source);
        }
        Closeable closeable = inputStream;
        boolean bl = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl2 = false;
            pair = INSTANCE.loadPactFromFile(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return pair;
    }

    private final boolean fileExists(String path) {
        return new File(path).exists();
    }

    private DefaultPactReader() {
    }

    static {
        DefaultPactReader defaultPactReader;
        INSTANCE = defaultPactReader = new DefaultPactReader();
    }

    public static final /* synthetic */ JsonValue.Object access$transformRequestResponseJson(DefaultPactReader $this, JsonValue.Object requestJson) {
        return $this.transformRequestResponseJson(requestJson);
    }
}

