/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.model.messaging;

import au.com.dius.pact.core.model.BasePact;
import au.com.dius.pact.core.model.Consumer;
import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.InvalidPactException;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.Provider;
import au.com.dius.pact.core.model.UnknownPactSource;
import au.com.dius.pact.core.model.messaging.Message;
import au.com.dius.pact.core.model.messaging.MessagePact;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.JsonKt;
import au.com.dius.pact.core.support.Utils;
import au.com.dius.pact.core.support.json.JsonParser;
import au.com.dius.pact.core.support.json.JsonValue;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 22\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00012BI\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u0012\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\"\u001a\u00020#H\u0016J\u0014\u0010$\u001a\u00020%2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u0016\u0010&\u001a\u00020\u00002\u000e\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020(0'J.\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020'H\u0016J\u001c\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\u000bH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0015\"\u0004\b\u0017\u0010\u0018R\"\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00063"}, d2={"Lau/com/dius/pact/core/model/messaging/MessagePact;", "Lau/com/dius/pact/core/model/BasePact;", "Lau/com/dius/pact/core/model/messaging/Message;", "provider", "Lau/com/dius/pact/core/model/Provider;", "consumer", "Lau/com/dius/pact/core/model/Consumer;", "messages", "", "metadata", "", "", "", "source", "Lau/com/dius/pact/core/model/PactSource;", "(Lau/com/dius/pact/core/model/Provider;Lau/com/dius/pact/core/model/Consumer;Ljava/util/List;Ljava/util/Map;Lau/com/dius/pact/core/model/PactSource;)V", "getConsumer", "()Lau/com/dius/pact/core/model/Consumer;", "interactions", "", "getInteractions", "()Ljava/util/List;", "getMessages", "setMessages", "(Ljava/util/List;)V", "getMetadata", "()Ljava/util/Map;", "getProvider", "()Lau/com/dius/pact/core/model/Provider;", "getSource", "()Lau/com/dius/pact/core/model/PactSource;", "equals", "", "other", "hashCode", "", "mergeInteractions", "", "mergePact", "Lau/com/dius/pact/core/model/Pact;", "Lau/com/dius/pact/core/model/Interaction;", "mergePacts", "pact", "pactFile", "Ljava/io/File;", "sortInteractions", "toMap", "pactSpecVersion", "Lau/com/dius/pact/core/model/PactSpecVersion;", "toString", "Companion", "model"})
public final class MessagePact
extends BasePact<Message> {
    @NotNull
    private final Provider provider;
    @NotNull
    private final Consumer consumer;
    @NotNull
    private List<Message> messages;
    @NotNull
    private final Map<String, Object> metadata;
    @NotNull
    private final PactSource source;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Map<String, Object> toMap(@NotNull PactSpecVersion pactSpecVersion) {
        Object object;
        Map.Entry it;
        Object object2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)pactSpecVersion), (String)"pactSpecVersion");
        if (pactSpecVersion.compareTo((Enum)PactSpecVersion.V3) < 0) {
            throw (Throwable)new InvalidPactException("Message pacts only support version 3+, cannot write pact specification " + "version " + (Object)((Object)pactSpecVersion));
        }
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to((Object)"consumer", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)this.getConsumer().getName())));
        pairArray[1] = TuplesKt.to((Object)"provider", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)this.getProvider().getName())));
        Iterable iterable = this.messages;
        String string = "messages";
        int n = 2;
        Pair[] pairArray2 = pairArray;
        Pair[] pairArray3 = pairArray;
        boolean $i$f$map = false;
        void var4_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Message message = (Message)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = ((Message)((Object)it)).toMap(pactSpecVersion);
            object2.add(object);
        }
        object2 = (List)destination$iv$iv;
        pairArray2[n] = TuplesKt.to((Object)string, (Object)object2);
        $this$map$iv = this.getMetadata().entrySet();
        object2 = BasePact.Companion;
        string = "metadata";
        n = 3;
        pairArray2 = pairArray3;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getKey(), (Object)Json.INSTANCE.toJson(it.getValue()));
            object.add(pair);
        }
        object = (List)destination$iv$iv;
        pairArray2[n] = TuplesKt.to((Object)string, ((BasePact.Companion)((Object)object2)).metaData((JsonValue)JsonKt.jsonObject((List)object), pactSpecVersion));
        return MapsKt.mapOf((Pair[])pairArray3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> mergePacts(@NotNull Map<String, ? extends Object> pact, @NotNull File pactFile) {
        Collection<Map> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(pact, (String)"pact");
        Intrinsics.checkParameterIsNotNull((Object)pactFile, (String)"pactFile");
        Map newPact = MapsKt.toMutableMap(pact);
        Object object = pactFile;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        Object object3 = object2;
        boolean bl3 = false;
        object3 = new FileInputStream((File)object3);
        bl3 = false;
        object2 = new InputStreamReader((InputStream)object3, charset);
        bl2 = false;
        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)object;
            boolean bl5 = false;
            it = JsonParser.INSTANCE.parseReader((Reader)it);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        BufferedReader json = it;
        String pactSpec = "pact-specification";
        Object version = Json.INSTANCE.extractFromJson((JsonValue)json, new String[]{"metadata", pactSpec, "version"});
        Object pactVersion = Utils.INSTANCE.extractFromMap(pact, new String[]{"metadata", pactSpec, "version"});
        if (version != null && Intrinsics.areEqual((Object)version, (Object)pactVersion) ^ true) {
            throw (Throwable)new InvalidPactException("Could not merge pact into '" + pactFile + "': pact specification version is " + pactVersion + ", while the file is version " + version);
        }
        if (json instanceof JsonValue.Object && json.has("interactions")) {
            throw (Throwable)new InvalidPactException("Could not merge pact into '" + pactFile + "': file is not a message pact " + "(it contains request/response interactions)");
        }
        Object v = newPact.get("messages");
        if (v == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.collections.Map<kotlin.String, kotlin.Any>>");
        }
        Iterable bl5 = json.get("messages").asArray().getValues();
        Collection collection2 = (List)v;
        boolean $i$f$map = false;
        object3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonValue jsonValue = (JsonValue)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl6 = false;
            Map map = Json.INSTANCE.toMap((JsonValue)it);
            collection.add(map);
        }
        collection = (List)destination$iv$iv;
        Iterable $this$distinctBy$iv = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
        boolean $i$f$distinctBy = false;
        HashSet set$iv = new HashSet();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Map it = (Map)e$iv;
            boolean bl7 = false;
            Object key$iv = it.get("description");
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List messages = list$iv;
        newPact.put("messages", messages);
        return newPact;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void mergeInteractions(@NotNull List<?> interactions2) {
        void $this$distinctBy$iv;
        Intrinsics.checkParameterIsNotNull(interactions2, (String)"interactions");
        Iterable iterable = CollectionsKt.plus((Collection)this.messages, (Iterable)interactions2);
        MessagePact messagePact = this;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Message it = (Message)e$iv;
            boolean bl = false;
            String key$iv = it.uniqueKey();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List list = list$iv;
        messagePact.messages = CollectionsKt.toMutableList((Collection)list);
        this.sortInteractions();
    }

    @Override
    @NotNull
    public List<Message> getInteractions() {
        return this.messages;
    }

    @Override
    @NotNull
    public Pact<Message> sortInteractions() {
        List<Message> $this$sortBy$iv = this.messages;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            List<Message> list = $this$sortBy$iv;
            boolean bl = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Message message = (Message)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)(CollectionsKt.joinToString$default((Iterable)message.getProviderStates(), null, null, null, (int)0, null, (Function1)sortInteractions.1.1.INSTANCE, (int)31, null) + message.getDescription()));
                    message = (Message)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = CollectionsKt.joinToString$default((Iterable)message.getProviderStates(), null, null, null, (int)0, null, (Function1)sortInteractions.1.1.INSTANCE, (int)31, null) + message.getDescription();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            };
            CollectionsKt.sortWith(list, (Comparator)comparator);
        }
        return this;
    }

    @NotNull
    public final MessagePact mergePact(@NotNull Pact<? extends Interaction> other) {
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        if (!(other instanceof MessagePact)) {
            throw (Throwable)new InvalidPactException("Unable to merge pact " + other + " as it is not a MessagePact");
        }
        this.mergeInteractions(((MessagePact)other).getInteractions());
        return this;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type au.com.dius.pact.core.model.messaging.MessagePact");
        }
        MessagePact cfr_ignored_0 = (MessagePact)object2;
        if (Intrinsics.areEqual((Object)this.getProvider(), (Object)((MessagePact)other).getProvider()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getConsumer(), (Object)((MessagePact)other).getConsumer()) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual(this.messages, ((MessagePact)other).messages) ^ true);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getProvider().hashCode();
        result = 31 * result + this.getConsumer().hashCode();
        result = 31 * result + ((Object)this.messages).hashCode();
        return result;
    }

    @Override
    @NotNull
    public String toString() {
        return "MessagePact(provider=" + this.getProvider() + ", consumer=" + this.getConsumer() + ", messages=" + this.messages + ", metadata=" + this.getMetadata() + ')';
    }

    @Override
    @NotNull
    public Provider getProvider() {
        return this.provider;
    }

    @Override
    @NotNull
    public Consumer getConsumer() {
        return this.consumer;
    }

    @NotNull
    public final List<Message> getMessages() {
        return this.messages;
    }

    public final void setMessages(@NotNull List<Message> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.messages = list;
    }

    @Override
    @NotNull
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public PactSource getSource() {
        return this.source;
    }

    @JvmOverloads
    public MessagePact(@NotNull Provider provider, @NotNull Consumer consumer, @NotNull List<Message> messages, @NotNull Map<String, ? extends Object> metadata, @NotNull PactSource source) {
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        Intrinsics.checkParameterIsNotNull(messages, (String)"messages");
        Intrinsics.checkParameterIsNotNull(metadata, (String)"metadata");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        super(consumer, provider, metadata, source);
        this.provider = provider;
        this.consumer = consumer;
        this.messages = messages;
        this.metadata = metadata;
        this.source = source;
    }

    public /* synthetic */ MessagePact(Provider provider, Consumer consumer, List list, Map map, PactSource pactSource, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            boolean bl = false;
            list = new ArrayList();
        }
        if ((n & 8) != 0) {
            map = BasePact.Companion.getDEFAULT_METADATA();
        }
        if ((n & 0x10) != 0) {
            pactSource = UnknownPactSource.INSTANCE;
        }
        this(provider, consumer, list, map, pactSource);
    }

    @JvmOverloads
    public MessagePact(@NotNull Provider provider, @NotNull Consumer consumer, @NotNull List<Message> messages, @NotNull Map<String, ? extends Object> metadata) {
        this(provider, consumer, messages, metadata, null, 16, null);
    }

    @JvmOverloads
    public MessagePact(@NotNull Provider provider, @NotNull Consumer consumer, @NotNull List<Message> messages) {
        this(provider, consumer, messages, null, null, 24, null);
    }

    @JvmOverloads
    public MessagePact(@NotNull Provider provider, @NotNull Consumer consumer) {
        this(provider, consumer, null, null, null, 28, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lau/com/dius/pact/core/model/messaging/MessagePact$Companion;", "Lmu/KLogging;", "()V", "fromJson", "Lau/com/dius/pact/core/model/messaging/MessagePact;", "json", "Lau/com/dius/pact/core/support/json/JsonValue$Object;", "source", "Lau/com/dius/pact/core/model/PactSource;", "model"})
    public static final class Companion
    extends KLogging {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MessagePact fromJson(@NotNull JsonValue.Object json, @NotNull PactSource source) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            JsonValue.Object transformedJson = DefaultPactReader.transformJson(json);
            Consumer consumer = Consumer.Companion.fromJson(transformedJson.get("consumer"));
            Provider provider = Provider.Companion.fromJson(transformedJson.get("provider"));
            Iterable $this$map$iv = transformedJson.get("messages").asArray().getValues();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonValue jsonValue = (JsonValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Message message = Message.Companion.fromJson(it.asObject());
                collection.add(message);
            }
            List messages = (List)destination$iv$iv;
            Map metadata = transformedJson.has("metadata") ? Json.INSTANCE.toMap(transformedJson.get("metadata")) : MapsKt.emptyMap();
            return new MessagePact(provider, consumer, CollectionsKt.toMutableList((Collection)messages), metadata, source);
        }

        public static /* synthetic */ MessagePact fromJson$default(Companion companion, JsonValue.Object object, PactSource pactSource, int n, Object object2) {
            if ((n & 2) != 0) {
                pactSource = UnknownPactSource.INSTANCE;
            }
            return companion.fromJson(object, pactSource);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

