/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.converter;

import javax.annotation.Nonnull;
import org.qubership.atp.ei.ntt.converter.JsRanges;

public class ReadOnlyTextJsMapping {
    private StringBuilder sb = new StringBuilder();
    private JsRanges ranges = new JsRanges();
    private boolean wasReadOnly = false;
    private int startRow = 0;
    private int startCol = 0;
    private int endRow = 0;
    private int endCol = 0;

    ReadOnlyTextJsMapping() {
    }

    public ReadOnlyTextJsMapping append(@Nonnull String text) {
        return this.append(text, false);
    }

    public ReadOnlyTextJsMapping append(@Nonnull String text, boolean isReadOnly) {
        if (text.isEmpty()) {
            return this;
        }
        this.sb.append(text);
        if (isReadOnly) {
            this.endCol += text.length();
        } else {
            if (this.wasReadOnly) {
                this.ranges.addRange(this.startRow, this.startCol, this.endRow, this.endCol);
            }
            this.endCol += text.length();
            this.startCol = this.endCol;
            this.startRow = this.endRow;
        }
        this.wasReadOnly = isReadOnly;
        return this;
    }

    public ReadOnlyTextJsMapping appendNewLine() {
        this.sb.append('\n');
        ++this.endRow;
        this.endCol = 0;
        if (!this.wasReadOnly) {
            this.startRow = this.endRow;
            this.startCol = this.endCol;
        }
        return this;
    }

    public String getReadOnlyRanges() {
        if (this.wasReadOnly) {
            this.ranges.addRange(this.startRow, this.startCol, this.endRow, this.endCol);
            this.startCol = this.endCol;
            this.startRow = this.endRow;
            this.wasReadOnly = false;
        }
        return this.ranges.toString();
    }

    public String getText() {
        return this.sb.toString();
    }
}

