/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.converter;

import java.util.Objects;
import org.qubership.atp.ei.ntt.converter.ModelItemTextConverter;
import org.qubership.atp.ei.ntt.converter.ReadOnlyTextJsMapping;
import org.qubership.atp.ei.ntt.converter.TextAppendMethod;
import org.qubership.atp.ei.ntt.converter.TextType;
import org.qubership.atp.ei.ntt.model.ModelItem;
import org.qubership.atp.ei.ntt.model.Reference;
import org.qubership.atp.ei.ntt.model.Template;
import org.qubership.atp.ei.ntt.model.TreeNode;
import org.qubership.atp.ei.ntt.model.enums.ModelItemType;

class TextAppender {
    private TextAppendMethod textAppendMethod;
    private ModelItemType startingModelItemType;
    private ModelItemType currentModelItemType;
    private String modelItemIndent = "";
    private ReadOnlyTextJsMapping mapping;
    private ModelItemTextConverter converter;
    private TextAppendMethod appendToEditor = new TextAppendMethod(){

        @Override
        public void append(ModelItem modelItem, boolean isReference) {
            boolean instanceOfTempl = modelItem instanceof Template;
            boolean instanceOfRef = modelItem instanceof Reference;
            if (!isReference) {
                isReference = instanceOfRef;
            }
            boolean isReadOnly = false;
            TextAppender.this.mapping.append(TextAppender.this.modelItemIndent, isReadOnly).append(TextAppender.this.getModelState(modelItem), isReadOnly);
            String tempModelItemName = modelItem.getName();
            boolean isLeaf = TextAppender.this.currentModelItemType.isLeaf();
            if (!isLeaf) {
                String tempModelItem = TextAppender.this.converter.getPrefix(TextAppender.this.currentModelItemType);
                if (instanceOfTempl) {
                    tempModelItem = "Template_" + tempModelItem;
                } else if (instanceOfRef) {
                    tempModelItemName = "Template_" + TextAppender.this.getRefName((Reference)modelItem);
                }
                TextAppender.this.mapping.append(tempModelItem, isReadOnly);
            }
            TextAppender.this.mapping.append(tempModelItemName, isReadOnly).append(TextAppender.this.getFlagString(modelItem), isReadOnly);
            if (!isLeaf) {
                TextAppender.this.inToHierarchy();
                for (TreeNode child : modelItem.getChildren()) {
                    TextAppender.this.mapping.appendNewLine();
                    TextAppender.this.textAppendMethod.append((ModelItem)child, isReference);
                }
                TextAppender.this.outFromHierarchy();
            }
        }
    };
    private TextAppendMethod appendToFile = new TextAppendMethod(){

        @Override
        public void append(ModelItem modelItem, boolean isReference) {
            TextAppender.this.mapping.append(TextAppender.this.modelItemIndent).append(TextAppender.this.getModelState(modelItem));
            String tempModelItemName = modelItem.getName();
            boolean isLeaf = TextAppender.this.currentModelItemType.isLeaf();
            if (!isLeaf) {
                String tempModelItem = TextAppender.this.converter.getPrefix(TextAppender.this.currentModelItemType);
                if (modelItem instanceof Template) {
                    tempModelItem = "Template_" + tempModelItem;
                } else if (modelItem instanceof Reference) {
                    tempModelItemName = "Template_" + TextAppender.this.getRefName((Reference)modelItem);
                    isReference = true;
                }
                TextAppender.this.mapping.append(tempModelItem);
            }
            TextAppender.this.mapping.append(tempModelItemName).append(TextAppender.this.getFlagString(modelItem));
            if (!isLeaf) {
                TextAppender.this.inToHierarchy();
                if (!isReference) {
                    for (TreeNode child : modelItem.getChildren()) {
                        TextAppender.this.mapping.appendNewLine();
                        TextAppender.this.textAppendMethod.append((ModelItem)child, false);
                    }
                }
                TextAppender.this.outFromHierarchy();
            }
        }
    };

    TextAppender(ModelItemTextConverter converter, TextType type, ModelItemType modelItemType, ReadOnlyTextJsMapping mapping) {
        this.converter = converter;
        this.startingModelItemType = modelItemType;
        this.setCurrentModelItemType(modelItemType);
        this.setType(type);
        this.mapping = mapping;
    }

    public void setType(TextType type) {
        switch (type) {
            case EDITOR: {
                this.textAppendMethod = this.appendToEditor;
                return;
            }
            case FILE: {
                this.textAppendMethod = this.appendToFile;
                return;
            }
        }
    }

    public void clearIndent() {
        this.startingModelItemType = this.currentModelItemType;
        this.generateModelItemIdent();
    }

    public void setCurrentModelItemType(ModelItemType modelItemsEnum) {
        this.currentModelItemType = modelItemsEnum;
        this.generateModelItemIdent();
    }

    public void appendModelItem(ModelItem modelItem, boolean isTemplatesTree) {
        if (isTemplatesTree) {
            this.textAppendMethod.append(modelItem, false);
        } else {
            boolean isReference = false;
            if (modelItem.isTemplate()) {
                isReference = true;
            }
            this.textAppendMethod.append(modelItem, isReference);
        }
    }

    private void inToHierarchy() {
        this.currentModelItemType = this.currentModelItemType.next();
        this.modelItemIndent = this.modelItemIndent + "    ";
    }

    private void outFromHierarchy() {
        this.currentModelItemType = this.currentModelItemType.previous();
        this.modelItemIndent = this.modelItemIndent.substring("    ".length());
    }

    private void generateModelItemIdent() {
        this.modelItemIndent = "";
        int iter = this.currentModelItemType.ordinal() - this.startingModelItemType.ordinal();
        for (int i = 0; i < iter; ++i) {
            this.modelItemIndent = this.modelItemIndent + "    ";
        }
    }

    private String getFlagString(ModelItem item) {
        String[] flags = item.getFlags();
        if (flags.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder("; flags=");
        for (String flag : flags) {
            if (result.length() > 8) {
                result.append(",");
            }
            result.append(flag);
        }
        return result.toString();
    }

    private String getModelState(ModelItem item) {
        if (!item.isEnabled()) {
            return "//";
        }
        return "";
    }

    private String getRefName(Reference ref) {
        String name = ref.getTemplProjName() + "\\" + ref.getTemplName();
        String refName = ref.getRefName();
        if (!refName.equals("") && !Objects.equals(refName, name)) {
            name = name + "\"" + refName + "\"";
        }
        return name;
    }
}

