/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.dto.enums;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ei.ntt.dto.enums.FlagEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Flags {
    INVERT_RESULT(UUID.fromString("5e482fa3-1f9b-42eb-52b8-789591342c78"), "Invert Result", FlagEntity.Type.EXECUTION),
    STOP_ON_FAIL(UUID.fromString("3e482af5-19fb-4e2b-82b5-879519342c68"), "Stop on fail", FlagEntity.Type.EXECUTION),
    SKIP_IF_DEPENDENCIES_FAIL(UUID.fromString("8596d3da-0226-4df8-9877-0a05f7784586"), "Skip if dependencies fail", FlagEntity.Type.EXECUTION),
    SKIP(UUID.fromString("5d9b8af2-9c21-4750-afda-b605f52cacec"), "Skip", FlagEntity.Type.EXECUTION),
    TERMINATE_IF_FAIL(UUID.fromString("547c84b1-4111-457d-bc7d-76e3a2a9d157"), "Terminate if fail", FlagEntity.Type.EXECUTION),
    COLLECT_LOGS(UUID.fromString("b7025ffb-fa42-4c70-997e-715bc8324946"), "Collect logs", FlagEntity.Type.COLLECTION),
    COLLECT_LOGS_ON_BLOCKED(UUID.fromString("6be63860-70b0-4643-b55b-af46c2d0295d"), "Collect logs on blocked", FlagEntity.Type.COLLECTION),
    COLLECT_LOGS_ON_FAIL(UUID.fromString("c9b450db-1799-4911-b804-25f4e808ef89"), "Collect logs on fail", FlagEntity.Type.COLLECTION),
    COLLECT_LOGS_ON_SKIPPED(UUID.fromString("adf75cc8-0dc6-4776-803f-8ab314c17fce"), "Collect logs on skipped", FlagEntity.Type.COLLECTION),
    COLLECT_LOGS_ON_WARNING(UUID.fromString("8a9db7a6-6ba6-4501-b4d3-9f09f8719afd"), "Collect logs on warning", FlagEntity.Type.COLLECTION);

    private static final Logger log;
    private static final Map<UUID, Flags> byIdIndex;
    private FlagEntity flagEntity;

    private Flags(UUID id, String name, FlagEntity.Type type) {
        this.flagEntity = new FlagEntity(id, name, type);
    }

    public static List<FlagEntity> getAll() {
        ArrayList<FlagEntity> flagEntityList = new ArrayList<FlagEntity>();
        for (Flags flags : Flags.values()) {
            flagEntityList.add(flags.getFlagEntity());
        }
        return flagEntityList;
    }

    public static Flags getById(UUID id) {
        Preconditions.checkNotNull((Object)((Object)byIdIndex.get(id)), (String)"Flag with ID %id does not exist", (Object)id);
        return byIdIndex.get(id);
    }

    public static List<Flags> getByIds(List<UUID> ids) {
        if (Objects.isNull(ids) || ids.size() == 0) {
            return null;
        }
        ArrayList<Flags> flags = new ArrayList<Flags>();
        ids.forEach(id -> {
            Preconditions.checkNotNull((Object)((Object)byIdIndex.get(id)), (String)"Flag with ID %id does not exist", (Object)id);
            flags.add(byIdIndex.get(id));
        });
        return flags;
    }

    public static List<UUID> getIdByValue(List<Flags> flags) {
        if (Objects.isNull(flags) || flags.size() == 0) {
            return null;
        }
        return flags.stream().flatMap(flag -> Flags.getKeysByValue(byIdIndex, flag).stream()).collect(Collectors.toList());
    }

    private static <V1, V2> Set<V1> getKeysByValue(Map<V1, V2> map, V2 value) {
        return map.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), value)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public static List<Flags> getByType(FlagEntity.Type type) {
        ArrayList<Flags> flagsList = new ArrayList<Flags>();
        for (Flags flags : Flags.values()) {
            if (!flags.getFlagEntity().getFlagType().equals((Object)type)) continue;
            flagsList.add(flags);
        }
        return flagsList;
    }

    public FlagEntity getFlagEntity() {
        return this.flagEntity;
    }

    public String getName() {
        return this.flagEntity.getName();
    }

    public UUID getId() {
        return this.flagEntity.getId();
    }

    public String toString() {
        return "Flags{flagEntity=" + this.flagEntity + '}';
    }

    static {
        log = LoggerFactory.getLogger(Flags.class);
        byIdIndex = Maps.newHashMapWithExpectedSize((int)Flags.values().length);
        for (Flags flag : Flags.values()) {
            byIdIndex.put(flag.getId(), flag);
        }
    }
}

