/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.model.enums;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.ei.ntt.model.ModelItem;
import org.qubership.atp.ei.ntt.model.NttTestCase;
import org.qubership.atp.ei.ntt.model.Project;
import org.qubership.atp.ei.ntt.model.TestAction;
import org.qubership.atp.ei.ntt.model.TestStep;
import org.qubership.atp.ei.ntt.model.TestSuite;

public enum ModelItemType {
    PROJECT(Project.class, "Project"),
    SUITE(TestSuite.class, "TestSuite"),
    CASE(NttTestCase.class, "TestCase"),
    STEP(TestStep.class, "TestStep"),
    ACTION(TestAction.class, "TestAction");

    private Class<? extends ModelItem> clazz;
    private String name;

    private ModelItemType(Class<? extends ModelItem> clazz, String name) {
        this.clazz = clazz;
        this.name = name;
    }

    public Class<? extends ModelItem> getInterface() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public ModelItemType next() {
        return this.ordinal() + 1 >= ModelItemType.values().length ? ModelItemType.values()[this.ordinal()] : ModelItemType.values()[this.ordinal() + 1];
    }

    public ModelItemType previous() {
        return this.ordinal() - 1 < 0 ? ModelItemType.values()[0] : ModelItemType.values()[this.ordinal() - 1];
    }

    @Nullable
    public static ModelItemType get(@Nonnull String name) {
        for (ModelItemType type : ModelItemType.values()) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    public boolean isLeaf() {
        return this.ordinal() == ModelItemType.values().length - 1;
    }

    public boolean isRoot() {
        return this.ordinal() == 0;
    }

    @Nonnull
    public <T extends ModelItem> T from(@Nonnull ModelItem instance) {
        ModelItemType instanceType = instance.getModelItemType();
        Preconditions.checkArgument((instanceType.ordinal() >= this.ordinal() ? 1 : 0) != 0, (String)"[%s] could not be a parent of [%s]{%s}", (Object)((Object)this), (Object)((Object)instanceType), (Object)instance);
        int advance = instanceType.ordinal() - this.ordinal();
        for (int i = 0; i < advance; ++i) {
            instance = (ModelItem)instance.getParent();
        }
        return (T)this.clazz.cast(instance);
    }
}

