/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.settings.model;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.qubership.atp.ei.ntt.settings.FileUtils;
import org.qubership.atp.ei.ntt.settings.model.IFile;

public class FileSettings
implements IFile {
    private File file;

    public FileSettings(String relatedPath) {
        this.setPathToFile(relatedPath);
    }

    public FileSettings(File file) {
        this.setFile(file);
    }

    @Override
    public void setPathToFile(String pathToFile) {
        File tmpFile = new File(pathToFile);
        if (FileUtils.isPathRelated(pathToFile = tmpFile.getAbsolutePath())) {
            pathToFile = FileUtils.getAbsolutePath(pathToFile);
        }
        this.file = new File(pathToFile);
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getFileName() {
        return this.file.getName();
    }

    public String getFileNameWithoutExt() {
        return FilenameUtils.removeExtension((String)this.file.getName());
    }

    @Override
    public String getAbsolutePathToFile() {
        return FileUtils.getPathToFile(this.file);
    }

    @Override
    public String getRelatedPathToFile() {
        return FileUtils.getRelatedPathToFile(this.file);
    }

    @Override
    public String getPathToSave() {
        if (FileUtils.isPathRelated(this.getRelatedPathToFile())) {
            return this.getRelatedPathToFile();
        }
        return this.getAbsolutePathToFile();
    }

    @Override
    public String getDirectoryPath() {
        return FileUtils.getPathToFile(this.file.getParentFile());
    }

    public boolean equals(FileSettings fileSettings) {
        if (fileSettings == null || fileSettings.getFile() == null) {
            return this.file == null;
        }
        if (this.file != null) {
            return this.getAbsolutePathToFile().equals(fileSettings.getAbsolutePathToFile());
        }
        return false;
    }
}

