/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.ntt.settings.store.option;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.qubership.atp.ei.ntt.settings.model.Option;
import org.qubership.atp.ei.ntt.settings.model.Options;
import org.qubership.atp.ei.ntt.settings.store.option.OptionProcessException;
import org.qubership.atp.ei.ntt.settings.store.option.OptionProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOptionProcessor<T>
implements OptionProcessor<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractOptionProcessor.class);

    @Override
    public void save(Object object, T source) {
        Class<?> daoClass = object.getClass();
        while (!daoClass.getSuperclass().equals(Object.class)) {
            for (Field field : daoClass.getDeclaredFields()) {
                if (field.getAnnotation(Option.class) != null) {
                    try {
                        this.saveOption(object, field, source);
                    }
                    catch (OptionProcessException e) {
                        this.getLog().error((Object)e);
                    }
                    continue;
                }
                if (field.getAnnotation(Options.class) == null) continue;
                try {
                    this.saveOptions(object, field, source);
                }
                catch (OptionProcessException e) {
                    this.getLog().error((Object)e);
                }
            }
            daoClass = daoClass.getSuperclass();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void saveOptions(Object object, Field field, T source) throws OptionProcessException {
        List toIterate;
        Type fieldGenericType = field.getGenericType();
        if (!(fieldGenericType instanceof ParameterizedType)) throw new OptionProcessException(String.format("Unknown field type: %s", fieldGenericType));
        Class fieldClass = (Class)((ParameterizedType)fieldGenericType).getRawType();
        Type fieldTypeParameter = ((ParameterizedType)fieldGenericType).getActualTypeArguments()[0];
        if (!Collection.class.isAssignableFrom(fieldClass)) throw new OptionProcessException(String.format("Unsupported raw type: %s", fieldClass));
        Class collectionClass = fieldTypeParameter instanceof ParameterizedType ? (Class)((ParameterizedType)fieldTypeParameter).getRawType() : (Class)fieldTypeParameter;
        Object fieldValue = this.getFieldValue(object, field);
        if (fieldValue == null) {
            toIterate = Lists.newArrayList();
        } else if (fieldValue instanceof List) {
            toIterate = (List)fieldValue;
        } else {
            toIterate = Lists.newArrayListWithCapacity((int)Iterables.size((Iterable)((Iterable)fieldValue)));
            toIterate.addAll((Collection)fieldValue);
        }
        String key = field.getAnnotation(Options.class).key();
        this.iterate(key, source, toIterate, collectionClass);
    }

    protected abstract void iterate(String var1, T var2, List<?> var3, Class<?> var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getFieldValue(Object object, Field field) {
        try {
            field.setAccessible(true);
            Object object2 = field.get(object);
            return object2;
        }
        catch (IllegalAccessException e) {
            this.getLog().error((Object)e);
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            field.setAccessible(false);
        }
    }

    protected abstract org.apache.log4j.Logger getLog();
}

