/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import biz.paluch.logging.gelf.intern.GelfSender;
import biz.paluch.logging.gelf.intern.GelfSenderConfiguration;
import biz.paluch.logging.gelf.intern.GelfSenderProvider;
import biz.paluch.logging.gelf.intern.sender.KafkaGelfSender;
import biz.paluch.logging.gelf.intern.sender.QueryStringParser;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.ByteArraySerializer;

public class KafkaGelfSenderProvider
implements GelfSenderProvider {
    private static final int BROKER_DEFAULT_PORT = 9092;

    @Override
    public boolean supports(String host) {
        return host != null && host.startsWith("kafka:");
    }

    @Override
    public GelfSender create(GelfSenderConfiguration configuration) {
        URI uri = URI.create(configuration.getHost());
        Map<String, String> options = QueryStringParser.parse(uri);
        Properties props = new Properties();
        for (Map.Entry<String, String> entry : options.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
        String brokers = KafkaGelfSenderProvider.getBrokerServers(configuration);
        props.setProperty("bootstrap.servers", brokers);
        String kafkaLogTopic = KafkaGelfSenderProvider.getTopic(uri);
        props.put("value.serializer", ByteArraySerializer.class.getName());
        props.put("key.serializer", ByteArraySerializer.class.getName());
        if (!props.containsKey("acks")) {
            props.put("acks", "all");
        } else {
            String acks = props.getProperty("acks");
            acks = "0".equalsIgnoreCase(acks) ? "1" : acks;
            props.put("acks", acks);
        }
        if (!props.containsKey("retries")) {
            props.put("retries", (Object)2);
        }
        KafkaProducer kafkaProducer = new KafkaProducer(props);
        return new KafkaGelfSender((KafkaProducer<byte[], byte[]>)kafkaProducer, kafkaLogTopic, configuration.getErrorReporter());
    }

    private static String getBrokerServers(GelfSenderConfiguration configuration) {
        String brokers;
        URI uri = URI.create(configuration.getHost());
        if (uri.getHost() != null) {
            brokers = uri.getHost();
            int port = uri.getPort() > 0 ? uri.getPort() : (configuration.getPort() > 0 ? configuration.getPort() : 9092);
            brokers = brokers + ":" + port;
        } else {
            brokers = uri.getAuthority();
        }
        if (brokers == null || brokers.isEmpty()) {
            throw new IllegalArgumentException("Kafka URI must specify bootstrap.servers.");
        }
        return brokers;
    }

    private static String getTopic(URI uri) {
        String fragment = uri.getFragment();
        if (fragment == null || fragment.isEmpty()) {
            throw new IllegalArgumentException("Kafka URI must specify log topic as fragment.");
        }
        return fragment;
    }
}

