/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.support.json;

import au.com.dius.pact.core.support.json.JsonException;
import au.com.dius.pact.core.support.json.JsonLexer;
import au.com.dius.pact.core.support.json.JsonSource;
import au.com.dius.pact.core.support.json.JsonToken;
import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Ok;
import com.github.michaelbull.result.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u0006\u0010 \u001a\u00020!J\u000f\u0010\"\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010#J\u0014\u0010$\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010&\u0012\u0004\u0012\u00020'0%J\"\u0010(\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020'0%2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120\u001cH\u0002J\u0016\u0010+\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010&\u0012\u0004\u0012\u00020'0%H\u0002J\u0016\u0010,\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010&\u0012\u0004\u0012\u00020'0%H\u0002J\u001c\u0010-\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%2\u0006\u0010.\u001a\u00020\u0012H\u0002J\u0014\u0010/\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020'0%H\u0002J\u0016\u00101\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010&\u0012\u0004\u0012\u00020'0%H\u0002J\u001d\u00102\u001a\b\u0012\u0004\u0012\u00020'032\b\u0010.\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u00104J\u0017\u00105\u001a\u00020\u001f2\b\u00106\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u00107R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\b\"\u0004\b\u000f\u0010\nR\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u00068"}, d2={"Lau/com/dius/pact/core/support/json/JsonLexer;", "", "json", "Lau/com/dius/pact/core/support/json/JsonSource;", "(Lau/com/dius/pact/core/support/json/JsonSource;)V", "character", "", "getCharacter", "()J", "setCharacter", "(J)V", "getJson", "()Lau/com/dius/pact/core/support/json/JsonSource;", "line", "getLine", "setLine", "validExponent", "", "", "[Ljava/lang/Character;", "validHexCharsLower", "Lkotlin/ranges/CharRange;", "validHexCharsUpper", "validHexDigits", "validNumberSuffixes", "consumeChars", "", "list", "", "predicate", "Lkotlin/Function1;", "", "documentPointer", "", "nextChar", "()Ljava/lang/Character;", "nextToken", "Lcom/github/michaelbull/result/Result;", "Lau/com/dius/pact/core/support/json/JsonToken;", "Lau/com/dius/pact/core/support/json/JsonException;", "scanDecimalNumber", "Lau/com/dius/pact/core/support/json/JsonToken$Decimal;", "chars", "scanFalse", "scanNull", "scanNumber", "next", "scanString", "Lau/com/dius/pact/core/support/json/JsonToken$StringValue;", "scanTrue", "unexpectedCharacter", "Lcom/github/michaelbull/result/Err;", "(Ljava/lang/Character;)Lcom/github/michaelbull/result/Err;", "validHex", "char", "(Ljava/lang/Character;)Z", "support"})
public final class JsonLexer {
    private long line;
    private long character;
    private final Character[] validNumberSuffixes;
    private final Character[] validExponent;
    private final CharRange validHexDigits;
    private final CharRange validHexCharsLower;
    private final CharRange validHexCharsUpper;
    @NotNull
    private final JsonSource json;

    public final long getLine() {
        return this.line;
    }

    public final void setLine(long l) {
        this.line = l;
    }

    public final long getCharacter() {
        return this.character;
    }

    public final void setCharacter(long l) {
        this.character = l;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Result<JsonToken, JsonException> nextToken() {
        Result result;
        Character next;
        block15: {
            block14: {
                next = this.nextChar();
                if (next == null) return (Result)new Ok(null);
                if (CharsKt.isWhitespace((char)next.charValue())) {
                    String string;
                    List chars = CollectionsKt.mutableListOf((Object[])new Character[]{next});
                    this.consumeChars(chars, (Function1<? super Character, Boolean>)((Function1)nextToken.1.INSTANCE));
                    char[] cArray = CollectionsKt.toCharArray((Collection)chars);
                    boolean bl = false;
                    String string2 = string = new String(cArray);
                    JsonToken.Whitespace whitespace = new JsonToken.Whitespace(string2);
                    result = (Result)new Ok((Object)whitespace);
                    return result;
                }
                if (next.charValue() == '-') break block14;
                char c = next.charValue();
                boolean bl = false;
                if (!Character.isDigit(c)) break block15;
            }
            result = this.scanNumber(next.charValue());
            return result;
        }
        if (next.charValue() == 't') {
            result = this.scanTrue();
            return result;
        }
        if (next.charValue() == 'f') {
            result = this.scanFalse();
            return result;
        }
        if (next.charValue() == 'n') {
            result = this.scanNull();
            return result;
        }
        if (next.charValue() == '\"') {
            result = this.scanString();
            return result;
        }
        if (next.charValue() == '[') {
            result = (Result)new Ok((Object)JsonToken.ArrayStart.INSTANCE);
            return result;
        }
        if (next.charValue() == ']') {
            result = (Result)new Ok((Object)JsonToken.ArrayEnd.INSTANCE);
            return result;
        }
        if (next.charValue() == '{') {
            result = (Result)new Ok((Object)JsonToken.ObjectStart.INSTANCE);
            return result;
        }
        if (next.charValue() == '}') {
            result = (Result)new Ok((Object)JsonToken.ObjectEnd.INSTANCE);
            return result;
        }
        if (next.charValue() == ',') {
            result = (Result)new Ok((Object)JsonToken.Comma.INSTANCE);
            return result;
        }
        if (next.charValue() == ':') {
            result = (Result)new Ok((Object)JsonToken.Colon.INSTANCE);
            return result;
        }
        result = (Result)this.unexpectedCharacter(next);
        return result;
    }

    private final Result<JsonToken, JsonException> scanNumber(char next) {
        Result result;
        List chars = CollectionsKt.mutableListOf((Object[])new Character[]{Character.valueOf(next)});
        this.consumeChars(chars, (Function1<? super Character, Boolean>)((Function1)scanNumber.1.INSTANCE));
        if (next == '-' && chars.size() == 1) {
            return (Result)new Err((Object)new JsonException("Invalid JSON (" + this.documentPointer() + "), found a '" + next + "' that was not followed by any digits"));
        }
        if (ArraysKt.contains((Object[])this.validNumberSuffixes, (Object)this.json.peekNextChar())) {
            result = this.scanDecimalNumber(chars);
        } else {
            String string;
            char[] cArray = CollectionsKt.toCharArray((Collection)chars);
            boolean bl = false;
            String string2 = string = new String(cArray);
            JsonToken.Integer integer = new JsonToken.Integer(string2);
            result = (Result)new Ok((Object)integer);
        }
        return result;
    }

    private final Result<JsonToken.Decimal, JsonException> scanDecimalNumber(List<Character> chars) {
        String string;
        boolean bl;
        block9: {
            char c;
            block11: {
                block10: {
                    Character next;
                    Character c2 = next = this.json.peekNextChar();
                    if (c2 != null && c2.charValue() == '.') {
                        Character c3 = this.json.nextChar();
                        if (c3 == null) {
                            Intrinsics.throwNpe();
                        }
                        chars.add(c3);
                        this.consumeChars(chars, (Function1<? super Character, Boolean>)((Function1)scanDecimalNumber.1.INSTANCE));
                        c = ((Character)CollectionsKt.last(chars)).charValue();
                        bl = false;
                        if (!Character.isDigit(c)) {
                            return (Result)new Err((Object)new JsonException("Invalid JSON (" + this.documentPointer() + "), '" + chars + "' is not a valid number"));
                        }
                        next = this.json.peekNextChar();
                    }
                    if (!ArraysKt.contains((Object[])this.validExponent, (Object)next)) break block9;
                    Character c4 = this.json.nextChar();
                    if (c4 == null) {
                        Intrinsics.throwNpe();
                    }
                    chars.add(c4);
                    Character c5 = next = this.json.peekNextChar();
                    if (c5 != null && c5.charValue() == '+') break block10;
                    Character c6 = next;
                    if (c6 == null || c6.charValue() != '-') break block11;
                }
                Character c7 = this.json.nextChar();
                if (c7 == null) {
                    Intrinsics.throwNpe();
                }
                chars.add(c7);
            }
            this.consumeChars(chars, (Function1<? super Character, Boolean>)((Function1)scanDecimalNumber.2.INSTANCE));
            c = ((Character)CollectionsKt.last(chars)).charValue();
            bl = false;
            if (!Character.isDigit(c)) {
                return (Result)new Err((Object)new JsonException("Invalid JSON (" + this.documentPointer() + "), '" + chars + "' is not a valid number"));
            }
        }
        char[] cArray = CollectionsKt.toCharArray((Collection)chars);
        bl = false;
        String string2 = string = new String(cArray);
        JsonToken.Decimal decimal = new JsonToken.Decimal(string2);
        return (Result)new Ok((Object)decimal);
    }

    private final Result<JsonToken.StringValue, JsonException> scanString() {
        String string;
        Character next;
        boolean bl = false;
        List chars = new ArrayList();
        do {
            Character c = next = this.json.nextChar();
            if (c != null && c.charValue() == '\\') {
                Character escapeCode;
                Character c2 = escapeCode = this.json.nextChar();
                if (c2 != null && c2.charValue() == '\"') {
                    chars.add(Character.valueOf('\"'));
                    continue;
                }
                Character c3 = escapeCode;
                if (c3 != null && c3.charValue() == '\\') {
                    chars.add(Character.valueOf('\\'));
                    continue;
                }
                Character c4 = escapeCode;
                if (c4 != null && c4.charValue() == '/') {
                    chars.add(Character.valueOf('/'));
                    continue;
                }
                Character c5 = escapeCode;
                if (c5 != null && c5.charValue() == 'b') {
                    chars.add(Character.valueOf('\b'));
                    continue;
                }
                Character c6 = escapeCode;
                if (c6 != null && c6.charValue() == 'f') {
                    chars.add(Character.valueOf('\f'));
                    continue;
                }
                Character c7 = escapeCode;
                if (c7 != null && c7.charValue() == 'n') {
                    chars.add(Character.valueOf('\n'));
                    continue;
                }
                Character c8 = escapeCode;
                if (c8 != null && c8.charValue() == 'r') {
                    chars.add(Character.valueOf('\r'));
                    continue;
                }
                Character c9 = escapeCode;
                if (c9 != null && c9.charValue() == 't') {
                    chars.add(Character.valueOf('\t'));
                    continue;
                }
                Character c10 = escapeCode;
                if (c10 != null && c10.charValue() == 'u') {
                    Character u1 = this.json.nextChar();
                    if (!this.validHex(u1)) {
                        return (Result)new Err((Object)new JsonException("Invalid JSON (" + this.documentPointer() + "), '" + u1 + "' is not a valid hex code character"));
                    }
                    if (u1 == null) {
                        return (Result)new Err((Object)new JsonException("Invalid JSON (" + this.documentPointer() + "), Unicode characters require 4 hex digits"));
                    }
                    Character u2 = this.json.nextChar();
                    if (!this.validHex(u2)) {
                        return (Result)new Err((Object)new JsonException("Invalid JSON (" + this.documentPointer() + "), '" + u2 + "' is not a valid hex code character"));
                    }
                    if (u2 == null) {
                        return (Result)new Err((Object)new JsonException("Invalid JSON (" + this.documentPointer() + "), Unicode characters require 4 hex digits"));
                    }
                    Character u3 = this.json.nextChar();
                    if (!this.validHex(u3)) {
                        return (Result)new Err((Object)new JsonException("Invalid JSON (" + this.documentPointer() + "), '" + u3 + "' is not a valid hex code character"));
                    }
                    if (u3 == null) {
                        return (Result)new Err((Object)new JsonException("Invalid JSON (" + this.documentPointer() + "), Unicode characters require 4 hex digits"));
                    }
                    Character u4 = this.json.nextChar();
                    if (!this.validHex(u4)) {
                        return (Result)new Err((Object)new JsonException("Invalid JSON (" + this.documentPointer() + "), '" + u4 + "' is not a valid hex code character"));
                    }
                    if (u4 == null) {
                        return (Result)new Err((Object)new JsonException("Invalid JSON (" + this.documentPointer() + "), Unicode characters require 4 hex digits"));
                    }
                    Object object = new char[]{u1.charValue(), u2.charValue(), u3.charValue(), u4.charValue()};
                    int n = 0;
                    object = new String((char[])object);
                    n = 16;
                    boolean bl2 = false;
                    int hex = Integer.parseInt((String)object, CharsKt.checkRadix((int)n));
                    chars.add(Character.valueOf((char)hex));
                    continue;
                }
                return (Result)new Err((Object)new JsonException("Invalid JSON (" + this.documentPointer() + "), '" + escapeCode + "' is not a valid escape code"));
            }
            if (next == null) {
                return (Result)new Err((Object)new JsonException("Invalid JSON (" + this.documentPointer() + "), End of document scanning for string terminator"));
            }
            if (next.charValue() == '\"') continue;
            chars.add(next);
        } while (next.charValue() != '\"');
        char[] cArray = CollectionsKt.toCharArray((Collection)chars);
        boolean bl3 = false;
        String string2 = string = new String(cArray);
        JsonToken.StringValue stringValue = new JsonToken.StringValue(string2);
        return (Result)new Ok((Object)stringValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validHex(Character c) {
        CharRange charRange = this.validHexDigits;
        boolean bl = false;
        if (c != null && charRange.contains(c.charValue())) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        charRange = this.validHexCharsLower;
        bl = false;
        if (c != null && charRange.contains(c.charValue())) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) return true;
        charRange = this.validHexCharsUpper;
        bl = false;
        if (c == null) return false;
        if (!charRange.contains(c.charValue())) return false;
        return true;
    }

    private final Err<JsonException> unexpectedCharacter(Character next) {
        return next == null ? new Err((Object)new JsonException("Invalid JSON (" + this.documentPointer() + "), unexpected end of the JSON document")) : new Err((Object)new JsonException("Invalid JSON (" + this.documentPointer() + "), found unexpected character '" + next + '\''));
    }

    @NotNull
    public final String documentPointer() {
        return "" + (this.line + 1L) + ':' + (this.character + 1L);
    }

    private final Result<JsonToken, JsonException> scanNull() {
        Character next = this.json.nextChar();
        if (next == null || next.charValue() != 'u') {
            return (Result)this.unexpectedCharacter(next);
        }
        next = this.json.nextChar();
        if (next == null || next.charValue() != 'l') {
            return (Result)this.unexpectedCharacter(next);
        }
        next = this.json.nextChar();
        if (next == null || next.charValue() != 'l') {
            return (Result)this.unexpectedCharacter(next);
        }
        return (Result)new Ok((Object)JsonToken.Null.INSTANCE);
    }

    private final Result<JsonToken, JsonException> scanFalse() {
        Character next = this.json.nextChar();
        if (next == null || next.charValue() != 'a') {
            return (Result)this.unexpectedCharacter(next);
        }
        next = this.json.nextChar();
        if (next == null || next.charValue() != 'l') {
            return (Result)this.unexpectedCharacter(next);
        }
        next = this.json.nextChar();
        if (next == null || next.charValue() != 's') {
            return (Result)this.unexpectedCharacter(next);
        }
        next = this.json.nextChar();
        if (next == null || next.charValue() != 'e') {
            return (Result)this.unexpectedCharacter(next);
        }
        return (Result)new Ok((Object)JsonToken.False.INSTANCE);
    }

    private final Result<JsonToken, JsonException> scanTrue() {
        Character next = this.json.nextChar();
        if (next == null || next.charValue() != 'r') {
            return (Result)this.unexpectedCharacter(next);
        }
        next = this.json.nextChar();
        if (next == null || next.charValue() != 'u') {
            return (Result)this.unexpectedCharacter(next);
        }
        next = this.json.nextChar();
        if (next == null || next.charValue() != 'e') {
            return (Result)this.unexpectedCharacter(next);
        }
        return (Result)new Ok((Object)JsonToken.True.INSTANCE);
    }

    private final void consumeChars(List<Character> list, Function1<? super Character, Boolean> predicate) {
        Character next = this.json.peekNextChar();
        while (next != null && ((Boolean)predicate.invoke((Object)next)).booleanValue()) {
            list.add(next);
            JsonSource.advance$default(this.json, 0, 1, null);
            next = this.json.peekNextChar();
        }
    }

    private final Character nextChar() {
        Character next = this.json.nextChar();
        if (next != null) {
            if (next.charValue() == '\n') {
                this.character = 0L;
                ++this.line;
            } else {
                ++this.character;
            }
        }
        return next;
    }

    @NotNull
    public final JsonSource getJson() {
        return this.json;
    }

    public JsonLexer(@NotNull JsonSource json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        this.json = json;
        this.validNumberSuffixes = new Character[]{Character.valueOf('.'), Character.valueOf('e'), Character.valueOf('E')};
        this.validExponent = new Character[]{Character.valueOf('e'), Character.valueOf('E')};
        char c = '0';
        this.validHexDigits = new CharRange(c, '9');
        c = 'a';
        this.validHexCharsLower = new CharRange(c, 'f');
        c = 'A';
        this.validHexCharsUpper = new CharRange(c, 'F');
    }
}

