/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.support.json;

import au.com.dius.pact.core.support.json.JsonException;
import au.com.dius.pact.core.support.json.JsonLexer;
import au.com.dius.pact.core.support.json.JsonSource;
import au.com.dius.pact.core.support.json.JsonToken;
import au.com.dius.pact.core.support.json.JsonValue;
import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Ok;
import com.github.michaelbull.result.Result;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lau/com/dius/pact/core/support/json/JsonParser;", "", "()V", "nextTokenOrThrow", "Lau/com/dius/pact/core/support/json/JsonToken;", "lexer", "Lau/com/dius/pact/core/support/json/JsonLexer;", "parse", "Lau/com/dius/pact/core/support/json/JsonValue;", "json", "Lau/com/dius/pact/core/support/json/JsonSource;", "parseArray", "Lau/com/dius/pact/core/support/json/JsonValue$Array;", "parseObject", "Lau/com/dius/pact/core/support/json/JsonValue$Object;", "parseReader", "reader", "Ljava/io/Reader;", "parseStream", "Ljava/io/InputStream;", "parseString", "", "support"})
public final class JsonParser {
    public static final JsonParser INSTANCE;

    @NotNull
    public final JsonValue parseString(@NotNull String json) throws JsonException {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        CharSequence charSequence = json;
        boolean bl = false;
        if (charSequence.length() > 0) {
            return this.parse(new JsonSource.StringSource(json, 0, 2, null));
        }
        throw (Throwable)new JsonException("Json document is empty");
    }

    @NotNull
    public final JsonValue parseStream(@NotNull InputStream json) throws JsonException {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        return this.parse(new JsonSource.InputStreamSource(json));
    }

    @NotNull
    public final JsonValue parseReader(@NotNull Reader reader) throws JsonException {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        return this.parse(new JsonSource.ReaderSource(reader));
    }

    private final JsonValue parse(JsonSource json) {
        JsonValue jsonValue;
        JsonLexer lexer = new JsonLexer(json);
        JsonToken token = this.nextTokenOrThrow(lexer);
        JsonToken jsonToken = token;
        if (jsonToken instanceof JsonToken.Integer) {
            jsonValue = new JsonValue.Integer(((JsonToken.Integer)token).toInteger());
        } else if (jsonToken instanceof JsonToken.Decimal) {
            jsonValue = new JsonValue.Decimal(((JsonToken.Decimal)token).toDecimal());
        } else if (jsonToken instanceof JsonToken.StringValue) {
            jsonValue = new JsonValue.StringValue(token.getChars());
        } else if (jsonToken instanceof JsonToken.True) {
            jsonValue = JsonValue.True.INSTANCE;
        } else if (jsonToken instanceof JsonToken.False) {
            jsonValue = JsonValue.False.INSTANCE;
        } else if (jsonToken instanceof JsonToken.Null) {
            jsonValue = JsonValue.Null.INSTANCE;
        } else if (jsonToken instanceof JsonToken.ArrayStart) {
            jsonValue = this.parseArray(lexer);
        } else if (jsonToken instanceof JsonToken.ObjectStart) {
            jsonValue = this.parseObject(lexer);
        } else {
            if (token != null) {
                throw (Throwable)new JsonException("Invalid Json document (" + lexer.documentPointer() + ") - found unexpected characters '" + token.getChars() + '\'');
            }
            throw (Throwable)new JsonException("Invalid Json document (" + lexer.documentPointer() + ") - found only whitespace characters");
        }
        JsonValue jsonValue2 = jsonValue;
        token = this.nextTokenOrThrow(lexer);
        if (token != null) {
            throw (Throwable)new JsonException("Invalid Json document (" + lexer.documentPointer() + ") - found unexpected characters '" + token.getChars() + '\'');
        }
        return jsonValue2;
    }

    private final JsonValue.Object parseObject(JsonLexer lexer) {
        boolean bl = false;
        Map map = new LinkedHashMap();
        JsonToken token = null;
        do {
            if ((token = this.nextTokenOrThrow(lexer)) instanceof JsonToken.ObjectEnd) continue;
            JsonToken jsonToken = token;
            if (jsonToken == null) {
                throw (Throwable)new JsonException("Invalid Json document (" + lexer.documentPointer() + ") - found end of document while parsing object");
            }
            if (!(jsonToken instanceof JsonToken.StringValue)) {
                throw (Throwable)new JsonException("Invalid Json document (" + lexer.documentPointer() + ") - expected a string but found unexpected characters " + '\'' + token.getChars() + '\'');
            }
            String key = token.getChars();
            token = this.nextTokenOrThrow(lexer);
            if (token == null) {
                throw (Throwable)new JsonException("Invalid Json document (" + lexer.documentPointer() + ") - found end of document while parsing object");
            }
            if (!(token instanceof JsonToken.Colon)) {
                throw (Throwable)new JsonException("Invalid Json document (" + lexer.documentPointer() + ") - expected a colon but found unexpected characters " + '\'' + token.getChars() + '\'');
            }
            token = this.nextTokenOrThrow(lexer);
            jsonToken = token;
            if (jsonToken == null) {
                throw (Throwable)new JsonException("Invalid Json document (" + lexer.documentPointer() + ") - found end of document while parsing object");
            }
            if (jsonToken instanceof JsonToken.Integer) {
                map.put(key, new JsonValue.Integer(((JsonToken.Integer)token).toInteger()));
            } else if (jsonToken instanceof JsonToken.Decimal) {
                map.put(key, new JsonValue.Decimal(((JsonToken.Decimal)token).toDecimal()));
            } else if (jsonToken instanceof JsonToken.StringValue) {
                map.put(key, new JsonValue.StringValue(token.getChars()));
            } else if (jsonToken instanceof JsonToken.True) {
                map.put(key, JsonValue.True.INSTANCE);
            } else if (jsonToken instanceof JsonToken.False) {
                map.put(key, JsonValue.False.INSTANCE);
            } else if (jsonToken instanceof JsonToken.Null) {
                map.put(key, JsonValue.Null.INSTANCE);
            } else if (jsonToken instanceof JsonToken.ArrayStart) {
                map.put(key, this.parseArray(lexer));
            } else if (jsonToken instanceof JsonToken.ObjectStart) {
                map.put(key, this.parseObject(lexer));
            } else {
                throw (Throwable)new JsonException("Invalid Json document (" + lexer.documentPointer() + ") - found unexpected characters '" + token.getChars() + '\'');
            }
            token = this.nextTokenOrThrow(lexer);
            if (token instanceof JsonToken.Comma || !(Intrinsics.areEqual((Object)token, (Object)JsonToken.ObjectEnd.INSTANCE) ^ true) || token == null) continue;
            throw (Throwable)new JsonException("Invalid Json document (" + lexer.documentPointer() + ") - found unexpected characters " + token.getChars());
        } while (token != null && Intrinsics.areEqual((Object)token, (Object)JsonToken.ObjectEnd.INSTANCE) ^ true);
        if (token == null) {
            throw (Throwable)new JsonException("Invalid Json document (" + lexer.documentPointer() + ") - found end of document while parsing object");
        }
        return new JsonValue.Object(map);
    }

    private final JsonValue.Array parseArray(JsonLexer lexer) {
        boolean bl = false;
        List array = new ArrayList();
        JsonToken token = null;
        do {
            if ((token = this.nextTokenOrThrow(lexer)) instanceof JsonToken.ArrayEnd) continue;
            JsonToken jsonToken = token;
            if (jsonToken == null) {
                throw (Throwable)new JsonException("Invalid Json document (" + lexer.documentPointer() + ") - found end of document while parsing array");
            }
            if (jsonToken instanceof JsonToken.Integer) {
                array.add(new JsonValue.Integer(((JsonToken.Integer)token).toInteger()));
            } else if (jsonToken instanceof JsonToken.Decimal) {
                array.add(new JsonValue.Decimal(((JsonToken.Decimal)token).toDecimal()));
            } else if (jsonToken instanceof JsonToken.StringValue) {
                array.add(new JsonValue.StringValue(token.getChars()));
            } else if (jsonToken instanceof JsonToken.True) {
                array.add(JsonValue.True.INSTANCE);
            } else if (jsonToken instanceof JsonToken.False) {
                array.add(JsonValue.False.INSTANCE);
            } else if (jsonToken instanceof JsonToken.Null) {
                array.add(JsonValue.Null.INSTANCE);
            } else if (jsonToken instanceof JsonToken.ArrayStart) {
                array.add(this.parseArray(lexer));
            } else if (jsonToken instanceof JsonToken.ObjectStart) {
                array.add(this.parseObject(lexer));
            } else {
                throw (Throwable)new JsonException("Invalid Json document (" + lexer.documentPointer() + ") - found unexpected characters " + token.getChars());
            }
            token = this.nextTokenOrThrow(lexer);
            if (token instanceof JsonToken.Comma || !(Intrinsics.areEqual((Object)token, (Object)JsonToken.ArrayEnd.INSTANCE) ^ true) || token == null) continue;
            throw (Throwable)new JsonException("Invalid Json document (" + lexer.documentPointer() + ") - found unexpected characters " + token.getChars());
        } while (token != null && Intrinsics.areEqual((Object)token, (Object)JsonToken.ArrayEnd.INSTANCE) ^ true);
        if (token == null) {
            throw (Throwable)new JsonException("Invalid Json document (" + lexer.documentPointer() + ") - found end of document while parsing array");
        }
        return new JsonValue.Array(array);
    }

    private final JsonToken nextTokenOrThrow(JsonLexer lexer) {
        Result<JsonToken, JsonException> next;
        JsonToken token = null;
        do {
            Result<JsonToken, JsonException> result;
            if ((result = (next = lexer.nextToken())) instanceof Err) {
                throw (Throwable)((Err)next).getError();
            }
            if (result instanceof Ok) continue;
            throw new NoWhenBranchMatchedException();
        } while ((token = (JsonToken)((Ok)next).getValue()) instanceof JsonToken.Whitespace);
        return token;
    }

    private JsonParser() {
    }

    static {
        JsonParser jsonParser;
        INSTANCE = jsonParser = new JsonParser();
    }
}

