/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.core.support.json;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H&J\u000f\u0010\u0007\u001a\u0004\u0018\u00010\bH&\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\n\u001a\u0004\u0018\u00010\bH&\u00a2\u0006\u0002\u0010\t\u0082\u0001\u0002\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lau/com/dius/pact/core/support/json/JsonSource;", "", "()V", "advance", "", "count", "", "nextChar", "", "()Ljava/lang/Character;", "peekNextChar", "InputStreamSource", "ReaderSource", "StringSource", "Lau/com/dius/pact/core/support/json/JsonSource$StringSource;", "Lau/com/dius/pact/core/support/json/JsonSource$ReaderSource;", "support"})
public abstract class JsonSource {
    @Nullable
    public abstract Character nextChar();

    @Nullable
    public abstract Character peekNextChar();

    public abstract void advance(int var1);

    public static /* synthetic */ void advance$default(JsonSource jsonSource, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: advance");
        }
        if ((n2 & 1) != 0) {
            n = 1;
        }
        jsonSource.advance(n);
    }

    private JsonSource() {
    }

    public /* synthetic */ JsonSource(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u000f\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u000f\u0010\u0013\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lau/com/dius/pact/core/support/json/JsonSource$StringSource;", "Lau/com/dius/pact/core/support/json/JsonSource;", "json", "", "index", "", "(Ljava/lang/String;I)V", "getIndex", "()I", "setIndex", "(I)V", "getJson", "()Ljava/lang/String;", "advance", "", "count", "nextChar", "", "()Ljava/lang/Character;", "peekNextChar", "support"})
    public static class StringSource
    extends JsonSource {
        @NotNull
        private final String json;
        private int index;

        @Override
        @Nullable
        public Character nextChar() {
            Character c = this.peekNextChar();
            if (c != null) {
                ++this.index;
            }
            return c;
        }

        @Override
        @Nullable
        public Character peekNextChar() {
            return this.index >= this.json.length() ? null : Character.valueOf(this.json.charAt(this.index));
        }

        @Override
        public void advance(int count) {
            this.index += count;
        }

        @NotNull
        public final String getJson() {
            return this.json;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        public StringSource(@NotNull String json, int index) {
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            super(null);
            this.json = json;
            this.index = index;
        }

        public /* synthetic */ StringSource(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            this(string, n);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lau/com/dius/pact/core/support/json/JsonSource$InputStreamSource;", "Lau/com/dius/pact/core/support/json/JsonSource$ReaderSource;", "json", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "getJson", "()Ljava/io/InputStream;", "support"})
    public static class InputStreamSource
    extends ReaderSource {
        @NotNull
        private final InputStream json;

        @NotNull
        public final InputStream getJson() {
            return this.json;
        }

        public InputStreamSource(@NotNull InputStream json) {
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            super(new InputStreamReader(new BufferedInputStream(json)));
            this.json = json;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000f\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u000f\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0002\u0010\u000fR\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lau/com/dius/pact/core/support/json/JsonSource$ReaderSource;", "Lau/com/dius/pact/core/support/json/JsonSource;", "reader", "Ljava/io/Reader;", "(Ljava/io/Reader;)V", "buffer", "", "Ljava/lang/Character;", "getReader", "()Ljava/io/Reader;", "advance", "", "count", "", "nextChar", "()Ljava/lang/Character;", "peekNextChar", "support"})
    public static class ReaderSource
    extends JsonSource {
        private Character buffer;
        @NotNull
        private final Reader reader;

        @Override
        @Nullable
        public Character nextChar() {
            Character c;
            if (this.buffer != null) {
                Character c2 = this.buffer;
                this.buffer = null;
                c = c2;
            } else {
                int next = this.reader.read();
                c = next == -1 ? null : Character.valueOf((char)next);
            }
            return c;
        }

        @Override
        @Nullable
        public Character peekNextChar() {
            if (this.buffer == null) {
                int next = this.reader.read();
                this.buffer = next == -1 ? null : Character.valueOf((char)next);
            }
            return this.buffer;
        }

        @Override
        public void advance(int count) {
            int n;
            if (this.buffer != null) {
                this.buffer = null;
                n = count - 1;
            } else {
                n = count;
            }
            int chars = n;
            this.reader.skip(chars);
        }

        @NotNull
        public final Reader getReader() {
            return this.reader;
        }

        public ReaderSource(@NotNull Reader reader) {
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            super(null);
            this.reader = reader;
        }
    }
}

