/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.kafka;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.kafka.TracingKafkaReceiverBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.kafka.ReactiveKafkaTracingPropagator;
import org.springframework.cloud.sleuth.instrument.kafka.TracingKafkaProducerFactory;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.kafka.receiver.KafkaReceiver;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={KafkaReceiver.class})
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.sleuth.kafka.enabled"}, matchIfMissing=true)
public class TracingReactorKafkaAutoConfiguration {
    @Bean
    ReactiveKafkaTracingPropagator reactiveKafkaTracingPropagator(Tracer tracer, Propagator propagator, Propagator.Getter<ConsumerRecord<?, ?>> extractor) {
        return new ReactiveKafkaTracingPropagator(tracer, propagator, extractor);
    }

    @Bean
    @ConditionalOnClass(value={KafkaReceiver.class})
    static BeanPostProcessor tracingKafkaReceiverBeanPostProcessor(ReactiveKafkaTracingPropagator reactiveKafkaTracingPropagator) {
        return new TracingKafkaReceiverBeanPostProcessor(reactiveKafkaTracingPropagator);
    }

    @Bean
    @ConditionalOnMissingBean
    TracingKafkaProducerFactory tracingKafkaProducerFactory(BeanFactory beanFactory) {
        return new TracingKafkaProducerFactory(beanFactory);
    }
}

