/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.reactor;

import java.io.Closeable;
import java.io.IOException;
import java.util.Queue;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.sleuth.autoconfig.instrument.reactor.SleuthReactorProperties;
import org.springframework.cloud.sleuth.autoconfig.instrument.reactor.TraceReactorAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import reactor.core.publisher.Hooks;
import reactor.core.scheduler.Schedulers;

class HookRegisteringBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
Closeable,
ApplicationContextAware {
    private static final Log log = LogFactory.getLog(HookRegisteringBeanFactoryPostProcessor.class);
    private ConfigurableApplicationContext springContext;

    HookRegisteringBeanFactoryPostProcessor() {
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        if (this.springContext != null) {
            HookRegisteringBeanFactoryPostProcessor.setupHooks(this.springContext);
        }
    }

    static void setupHooks(ConfigurableApplicationContext springContext) {
        ConfigurableEnvironment environment = springContext.getEnvironment();
        SleuthReactorProperties.InstrumentationType property = (SleuthReactorProperties.InstrumentationType)((Object)environment.getProperty("spring.sleuth.reactor.instrumentation-type", SleuthReactorProperties.InstrumentationType.class, (Object)SleuthReactorProperties.InstrumentationType.DECORATE_ON_EACH));
        if (HookRegisteringBeanFactoryPostProcessor.wrapperNotOnClasspathHooksPropertyTurnedOn(property)) {
            log.warn((Object)"You have explicitly set the decorate hooks option but you're using an old version of Reactor. Please upgrade to the latest Boot version (at least 2.4.3). Will fall back to the previous reactor instrumentation mode");
            property = SleuthReactorProperties.InstrumentationType.DECORATE_ON_EACH;
        }
        if (property == SleuthReactorProperties.InstrumentationType.DECORATE_QUEUES) {
            HookRegisteringBeanFactoryPostProcessor.addQueueWrapper(springContext);
            HookRegisteringBeanFactoryPostProcessor.decorateOnLast(ReactorSleuth.scopePassingSpanOperator((ConfigurableApplicationContext)springContext));
            HookRegisteringBeanFactoryPostProcessor.decorateScheduler(springContext);
        } else {
            Boolean decorateOnEach = (Boolean)environment.getProperty("spring.sleuth.reactor.decorate-on-each", Boolean.class, (Object)true);
            if (!decorateOnEach.booleanValue()) {
                log.warn((Object)"You're using the deprecated [spring.sleuth.reactor.decorate-on-each] property. Please use the [spring.sleuth.reactor.instrumentation-type] one instead.");
                HookRegisteringBeanFactoryPostProcessor.decorateOnLast(ReactorSleuth.scopePassingSpanOperator((ConfigurableApplicationContext)springContext));
            } else if (property == SleuthReactorProperties.InstrumentationType.DECORATE_ON_EACH) {
                HookRegisteringBeanFactoryPostProcessor.decorateOnEach(springContext);
                HookRegisteringBeanFactoryPostProcessor.decorateOnLast(ReactorSleuth.onLastOperatorForOnEachInstrumentation((ConfigurableApplicationContext)springContext));
                HookRegisteringBeanFactoryPostProcessor.decorateScheduler(springContext);
            } else if (property == SleuthReactorProperties.InstrumentationType.DECORATE_ON_LAST) {
                HookRegisteringBeanFactoryPostProcessor.decorateOnLast(ReactorSleuth.scopePassingSpanOperator((ConfigurableApplicationContext)springContext));
                HookRegisteringBeanFactoryPostProcessor.decorateScheduler(springContext);
            } else if (property == SleuthReactorProperties.InstrumentationType.MANUAL) {
                HookRegisteringBeanFactoryPostProcessor.decorateOnLast(ReactorSleuth.springContextSpanOperator((ConfigurableApplicationContext)springContext));
            }
        }
    }

    private static boolean wrapperNotOnClasspathHooksPropertyTurnedOn(SleuthReactorProperties.InstrumentationType property) {
        return property == SleuthReactorProperties.InstrumentationType.DECORATE_QUEUES && !TraceReactorAutoConfiguration.TraceReactorConfiguration.IS_QUEUE_WRAPPER_ON_THE_CLASSPATH;
    }

    private static void decorateScheduler(ConfigurableApplicationContext springContext) {
        Schedulers.onScheduleHook((String)"sleuth", (Function)ReactorSleuth.scopePassingOnScheduleHook((ConfigurableApplicationContext)springContext));
    }

    private static void decorateOnLast(Function<? super Publisher<Object>, ? extends Publisher<Object>> function) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Decorating onLast operator instrumentation");
        }
        Hooks.onLastOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY, function);
    }

    private static void decorateOnEach(ConfigurableApplicationContext springContext) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Decorating onEach operator instrumentation");
        }
        Hooks.onEachOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY, (Function)ReactorSleuth.onEachOperatorForOnEachInstrumentation((ConfigurableApplicationContext)springContext));
    }

    static void addQueueWrapper(ConfigurableApplicationContext springContext) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Decorating queues");
        }
        Hooks.addQueueWrapper((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY, queue -> ReactorSleuth.traceQueue((ConfigurableApplicationContext)springContext, (Queue)queue));
    }

    @Override
    public void close() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Cleaning up hooks");
        }
        Hooks.resetOnEachOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY);
        Hooks.resetOnLastOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY);
        Hooks.removeQueueWrapper((String)"sleuth");
        Schedulers.resetOnScheduleHook((String)"sleuth");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Setting context for HookRegisteringBeanFactoryPostProcessor: [" + applicationContext + "]"));
        }
        if (!(applicationContext instanceof ConfigurableApplicationContext)) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Cannot set up tracing hooks for non-configurable application context: [" + applicationContext + "]"));
            }
            return;
        }
        this.springContext = (ConfigurableApplicationContext)applicationContext;
    }
}

