/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.composite.AbstractCollectionConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayConverter
extends AbstractCollectionConverter {
    @Override
    public boolean canConvert(Class<?> type) {
        return type.isArray();
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value = this.fromExpression(configuration, evaluator);
        if (type.isInstance(value)) {
            return value;
        }
        try {
            Collection<Object> elements;
            Class<?> elementType = type.getComponentType();
            if (null == value) {
                elements = this.fromChildren(lookup, configuration, type, enclosingType, loader, evaluator, listener, elementType);
            } else if (value instanceof String && ("".equals(value) || !value.equals(configuration.getValue()))) {
                PlexusConfiguration xml = ArrayConverter.csvToXml(configuration, (String)value);
                elements = this.fromChildren(lookup, xml, type, enclosingType, loader, evaluator, listener, elementType);
            } else if (value instanceof Collection) {
                elements = (Collection<Object>)value;
            } else {
                this.failIfNotTypeCompatible(value, type, configuration);
                elements = Collections.emptyList();
            }
            return elements.toArray((Object[])Array.newInstance(elementType, elements.size()));
        }
        catch (ComponentConfigurationException e) {
            if (null == e.getFailedConfiguration()) {
                e.setFailedConfiguration(configuration);
            }
            throw e;
        }
        catch (ArrayStoreException e) {
            throw new ComponentConfigurationException(configuration, "Cannot store value into array", e);
        }
    }

    @Override
    protected final Collection<Object> instantiateCollection(PlexusConfiguration configuration, Class<?> type, ClassLoader loader) {
        return new ArrayList<Object>(configuration.getChildCount());
    }
}

