/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus.binders;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import java.lang.annotation.Annotation;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.sisu.binders.QualifiedTypeBinder;
import org.eclipse.sisu.locators.BeanDescription;
import org.eclipse.sisu.plexus.config.Roles;
import org.eclipse.sisu.plexus.scanners.PlexusTypeListener;
import org.eclipse.sisu.reflect.DeferredClass;
import org.eclipse.sisu.scanners.QualifiedTypeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlexusTypeBinder
implements PlexusTypeListener {
    private final Binder binder;
    private final QualifiedTypeListener qualifiedTypeBinder;

    public PlexusTypeBinder(Binder binder) {
        this.binder = binder;
        this.qualifiedTypeBinder = new QualifiedTypeBinder(binder);
    }

    public void hear(Annotation qualifier, Class<?> qualifiedType, Object source) {
        this.qualifiedTypeBinder.hear(qualifier, qualifiedType, source);
    }

    @Override
    public void hear(Component component, DeferredClass<?> clazz, Object source) {
        Key<?> roleKey = Roles.componentKey(component);
        String strategy = component.instantiationStrategy();
        Class role = component.role();
        Binder componentBinder = this.componentBinder(source, component.description());
        Object sbb = role.getName().equals(clazz.getName()) ? (roleKey.getAnnotation() != null ? componentBinder.bind(roleKey).to(role) : componentBinder.bind(roleKey)) : ("load-on-start".equals(strategy) ? componentBinder.bind(roleKey).to(clazz.load()) : componentBinder.bind(roleKey).toProvider((Provider)clazz.asProvider()));
        if ("load-on-start".equals(strategy)) {
            sbb.asEagerSingleton();
        } else if (!"per-lookup".equals(strategy)) {
            sbb.in(Scopes.SINGLETON);
        }
    }

    private Binder componentBinder(Object source, String description) {
        if (null != description && description.length() > 0) {
            return this.binder.withSource((Object)new PlexusBeanDescription(source, description));
        }
        return this.binder.withSource(source);
    }

    private static final class PlexusBeanDescription
    implements BeanDescription {
        private final Object source;
        private final String description;

        PlexusBeanDescription(Object source, String description) {
            this.source = source;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.source.toString();
        }
    }
}

