/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.node.controllers;

import java.util.UUID;
import org.qubership.atp.ei.node.dto.ExportNodeInfo;
import org.qubership.atp.ei.node.dto.RunNodeRequest;
import org.qubership.atp.ei.node.services.ExportNodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ei/api/v1/node/export"})
public class ExportNodeController {
    private static final Logger log = LoggerFactory.getLogger(ExportNodeController.class);
    private final ExportNodeService exportService;

    @GetMapping(value={"/ping"})
    public ExportNodeInfo ping() {
        return this.exportService.getExportNodeInfo(true);
    }

    @PostMapping(value={"/run"})
    public ResponseEntity run(@RequestBody RunNodeRequest request) {
        if (this.isRequestEmpty(request)) {
            log.info("Empty request is received");
            return ResponseEntity.badRequest().build();
        }
        this.exportService.runExport(request);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/cancel"})
    public ResponseEntity cancel(@RequestParam(value="projectId") UUID projectId, @RequestParam(value="taskId") String taskId, @RequestParam(value="processId") String processId) {
        this.exportService.cancelExport(projectId, taskId, processId);
        return ResponseEntity.ok().build();
    }

    private boolean isRequestEmpty(RunNodeRequest request) {
        return request.getProjectId() == null && request.getTaskId() == null;
    }

    @DeleteMapping(value={"{projectId}/delete/{taskId}"})
    public ResponseEntity delete(@PathVariable(value="projectId") UUID projectId, @PathVariable(value="taskId") String taskId) {
        this.exportService.deleteExportFile(projectId, taskId);
        return ResponseEntity.ok().build();
    }

    public ExportNodeController(ExportNodeService exportService) {
        this.exportService = exportService;
    }
}

