/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.node.services;

import com.google.common.base.Stopwatch;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetricsExportImportService {
    private static final Logger log = LoggerFactory.getLogger(MetricsExportImportService.class);
    public static final String TOTAL_TIME_OF_EXPORT_PROCESSES = "total.time.export.processes";
    public static final String TOTAL_TIME_OF_IMPORT_PROCESSES = "total.time.import.processes";
    public static final String ACTIVE_EXPORT_PROCESS_COUNT = "active.export.process.count";
    public static final String ACTIVE_IMPORT_PROCESS_COUNT = "active.import.process.count";
    private static final String PROJECT_ID = "projectId";
    private static final String PROCESS_ID = "processId";
    private Map<String, Meter.Id> activeThreadCountMap = new ConcurrentHashMap<String, Meter.Id>();
    private final MeterRegistry meterRegistry;

    @Autowired
    public MetricsExportImportService(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void registerProcess(@NonNull String projectId, String processId, String metricName) {
        if (projectId == null) {
            throw new NullPointerException("projectId is marked non-null but is null");
        }
        Counter counter = Counter.builder((String)metricName).tag(PROJECT_ID, projectId).tag(PROCESS_ID, processId).register(this.meterRegistry);
        counter.increment();
        this.activeThreadCountMap.put(processId, counter.getId());
    }

    public void addTimeMetric(UUID projectId, Stopwatch timer, String metricName) {
        timer.stop();
        this.meterRegistry.timer(metricName, new String[]{PROJECT_ID, projectId.toString()}).record(timer.elapsed());
    }

    public void unregisterProcess(UUID processId) {
        Meter.Id id = this.activeThreadCountMap.get(processId.toString());
        if (id != null) {
            this.meterRegistry.remove(id);
            this.activeThreadCountMap.remove(processId.toString());
        }
    }
}

