/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.component;

import brave.ScopedSpan;
import brave.Tracer;
import java.util.Optional;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.qubership.atp.integration.configuration.annotation.AtpJaegerLog;
import org.qubership.atp.integration.configuration.annotation.AtpSpanTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AtpJaegerLogAspect {
    private static final Logger log = LoggerFactory.getLogger(AtpJaegerLogAspect.class);
    private final Tracer tracer;
    private final ExpressionParser expressionParser = new SpelExpressionParser();

    public AtpJaegerLogAspect(@Autowired(required=false) Tracer tracer) {
        this.tracer = tracer;
    }

    @Around(value="@annotation(atpJaegerLog)")
    public Object jaegerLog(ProceedingJoinPoint joinPoint, AtpJaegerLog atpJaegerLog) throws Throwable {
        Optional<ScopedSpan> nextSpan = Optional.ofNullable(this.tracer).map(t -> {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            return t.startScopedSpan(signature.getDeclaringType().getSimpleName() + "." + signature.getMethod().getName() + "()");
        });
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Exception e) {
            nextSpan.ifPresent(span -> span.error((Throwable)e));
            throw e;
        }
        finally {
            nextSpan.ifPresent(span -> {
                for (AtpSpanTag spanTag : atpJaegerLog.spanTags()) {
                    span.tag(spanTag.key(), this.getValue(joinPoint, spanTag.value()));
                }
                for (String mdcSpan : atpJaegerLog.mdcToTag()) {
                    if (MDC.get((String)mdcSpan) == null) continue;
                    span.tag(mdcSpan, MDC.get((String)mdcSpan));
                }
                span.finish();
            });
        }
    }

    private String getValue(ProceedingJoinPoint joinPoint, String argument) {
        Object[] args = joinPoint.getArgs();
        if (argument.startsWith("#")) {
            String[] parametersNames = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
            for (int id = 0; id < parametersNames.length; ++id) {
                if (!argument.startsWith("#" + parametersNames[id] + ".") && !argument.equals("#" + parametersNames[id])) continue;
                return this.parseExpression(args, argument.replaceFirst("#" + parametersNames[id], "[" + id + "]"));
            }
        }
        return this.parseExpression(args, argument);
    }

    private String parseExpression(Object[] args, String argument) {
        try {
            return (String)this.expressionParser.parseExpression(argument).getValue((Object)args);
        }
        catch (Exception e) {
            return argument;
        }
    }
}

